"use strict";

module.exports = function (def, api, ctx, delta, globalCallback) {
    try {
        const threadID = delta.messageMetadata?.threadKey?.threadFbId || delta.messageMetadata?.cid?.conversationFbid || null;
        const author = delta.messageMetadata?.actorFbId?.toString() || null;
        const timestamp = delta.messageMetadata?.timestamp || null;
        const messageID = delta.messageMetadata?.messageId || null;
        const logMessageBody = delta.messageMetadata?.adminText || null;
        const name = delta.name || null;
        const eventObj = {
            type: "event",
            threadID: threadID?.toString() || null,
            logMessageType: "log:thread-name",
            logMessageBody: logMessageBody,
            author: author,
            name: name,
            messageID: messageID,
            timestamp: timestamp,
        };

        return globalCallback(null, eventObj);
    } catch (err) {
        return globalCallback({
            error: "Problem parsing ThreadName delta",
            detail: err,
            res: delta,
            type: "parse_error"
        });
    }
};
