const utils = require('../../../helpers');

module.exports = (def, api, ctx, delta, globalCallback) => {
    const meta = delta.messageMetadata;
    if (!meta) return;

    globalCallback(null, {
        type: 'event',
        threadID: utils.formatID(
            meta.threadKey?.threadFbId || meta.threadKey?.otherUserFbId || meta.cid?.conversationFbid
        ),
        messageID: meta.messageId,
        logMessageType: 'log:unsubscribe',
        logMessageData: {
            leftParticipantFbId: delta.leftParticipantFbId?.toString()
        },
        logMessageBody: meta.adminText || '',
        timestamp: meta.timestamp,
        author: meta.actorFbId?.toString(),
        participants: delta.participants
    });
};
