const utils = require('../../../helpers');
const log = require('npmlog');
const markDelivery = utils.markDelivery;

module.exports = function (def, api, ctx, delta, globalCallback) {
  const clientPayload = JSON.parse(Buffer.from(delta.payload).toString("utf8"));
  if (!clientPayload?.deltas) return;

  for (const d of clientPayload.deltas) {
    if (d.deltaMessageReaction && ctx.globalOptions.listenEvents) {
      const dr = d.deltaMessageReaction;
      globalCallback(null, {
        type: "message_reaction",
        threadID: String(dr.threadKey.threadFbId || dr.threadKey.otherUserFbId),
        messageID: dr.messageId,
        reaction: dr.reaction,
        senderID: String(dr.senderId == 0 ? dr.userId : dr.senderId),
        userID: String(dr.userId || dr.senderId)
      });
    }

    else if (d.deltaRecallMessageData && ctx.globalOptions.listenEvents) {
      const du = d.deltaRecallMessageData;
      globalCallback(null, {
        type: "message_unsend",
        threadID: String(du.threadKey.threadFbId || du.threadKey.otherUserFbId),
        messageID: du.messageID,
        senderID: String(du.senderID),
        timestamp: du.deletionTimestamp
      });
    }

    else if (d.deltaRemoveMessage && ctx.globalOptions.listenEvents) {
      const dm = d.deltaRemoveMessage;
      globalCallback(null, {
        type: "message_self_delete",
        threadID: String(dm.threadKey.threadFbId || dm.threadKey.otherUserFbId),
        messageID: dm.messageIds.length === 1 ? dm.messageIds[0] : dm.messageIds,
        senderID: api.getCurrentUserID(),
        deletionTimestamp: dm.deletionTimestamp,
        timestamp: dm.timestamp
      });
    }

    else if (d.deltaMessageReply) {
      const r = d.deltaMessageReply;
      const msg = r.message;
      const mdata = msg?.data?.prng ? JSON.parse(msg.data.prng) : [];
      const mentions = Object.fromEntries(mdata.map(u => [u.i, (msg.body || "").substring(u.o, u.o + u.l)]));

      const attachments = (() => {
        const raw = (msg.attachments || []).map(att => {
          try { Object.assign(att, JSON.parse(att.mercuryJSON)); } catch {}
          try { return utils.formatAttachment(att); } catch (ex) { att.error = ex; att.type = "unknown"; return att; }
        });
        return raw.length === 1 ? raw[0] : raw;
      })();

      const callbackToReturn = {
        type: "message_reply",
        threadID: String(msg.messageMetadata.threadKey.threadFbId || msg.messageMetadata.threadKey.otherUserFbId),
        messageID: msg.messageMetadata.messageId,
        senderID: String(msg.messageMetadata.actorFbId),
        body: msg.body || "",
        isGroup: !!msg.messageMetadata.threadKey.threadFbId,
        mentions,
        timestamp: msg.messageMetadata.timestamp,
        participantIDs: (msg.messageMetadata.cid?.canonicalParticipantFbids || msg.participants || []).map(e => e.toString()),
        attachments
      };

      if (r.repliedToMessage) {
        const rm = r.repliedToMessage;
        const rmdata = rm?.data?.prng ? JSON.parse(rm.data.prng) : [];
        const rmentions = Object.fromEntries(rmdata.map(u => [u.i, (rm.body || "").substring(u.o, u.o + u.l)]));
        const replyAttachments = (() => {
          const raw = (rm.attachments || []).map(att => {
            try { Object.assign(att, JSON.parse(att.mercuryJSON)); } catch {}
            try { return utils.formatAttachment(att); } catch (ex) { att.error = ex; att.type = "unknown"; return att; }
          });
          return raw.length === 1 ? raw[0] : raw;
        })();

        callbackToReturn.messageReply = {
          threadID: String(rm.messageMetadata.threadKey.threadFbId || rm.messageMetadata.threadKey.otherUserFbId),
          messageID: rm.messageMetadata.messageId,
          senderID: String(rm.messageMetadata.actorFbId),
          body: rm.body || "",
          isGroup: !!rm.messageMetadata.threadKey.threadFbId,
          mentions: rmentions,
          timestamp: rm.messageMetadata.timestamp,
          attachments: replyAttachments
        };
      }

      else if (r.replyToMessageId) {
        return def.post("https://www.facebook.com/api/graphqlbatch/", ctx.jar, {
          av: ctx.globalOptions.pageID,
          queries: JSON.stringify({
            o0: {
              doc_id: "2848441488556444",
              query_params: { thread_and_message_id: { thread_id: callbackToReturn.threadID, message_id: r.replyToMessageId.id } }
            }
          })
        })
        .then(utils.parseAndCheckLogin(ctx, def))
        .then(resData => {
          if (resData[resData.length - 1].error_results > 0) throw resData[0].o0.errors;
          const data = resData[0].o0.data.message;
          const mobj = Object.fromEntries(data.message.ranges.map(n => [n.entity.id, (data.message.text || "").substr(n.offset, n.length)]));
          const fetchedAttachments = (() => {
            const raw = (data.message.blob_attachment || []).map(att => {
              try { return utils.formatAttachment({ blob_attachment: att }); } catch (ex) { att.error = ex; att.type = "unknown"; return att; }
            });
            return raw.length === 1 ? raw[0] : raw;
          })();

          callbackToReturn.messageReply = {
            threadID: callbackToReturn.threadID,
            messageID: data.message_id,
            senderID: data.message_sender.id.toString(),
            body: data.message.text || "",
            isGroup: callbackToReturn.isGroup,
            mentions: mobj,
            timestamp: parseInt(data.timestamp_precise),
            attachments: fetchedAttachments
          };
        })
        .catch(err => log.error("forcedFetch", err))
        .finally(() => {
          if (ctx.globalOptions.autoMarkDelivery) markDelivery(ctx, api, callbackToReturn.threadID, callbackToReturn.messageID);
          if (!ctx.globalOptions.selfListen || (callbackToReturn.senderID !== ctx.i_userID && callbackToReturn.senderID !== ctx.userID))
            globalCallback(null, callbackToReturn);
        });
      }

      else callbackToReturn.delta = d;

      if (ctx.globalOptions.autoMarkDelivery)
        markDelivery(ctx, api, callbackToReturn.threadID, callbackToReturn.messageID);

      if (!ctx.globalOptions.selfListen || (callbackToReturn.senderID !== ctx.i_userID && callbackToReturn.senderID !== ctx.userID))
        globalCallback(null, callbackToReturn);
    }
  }
};
