const utils = require('../../../helpers');
const log = require('npmlog');

function formatDeltaMessage(delta) {
    const md = delta.messageMetadata;
    const mdata = delta.data?.prng ? JSON.parse(delta.data.prng) : [];
    const mentions = {};

    for (const u of mdata) {
        mentions[u.i] = (delta.body || "").substring(u.o, u.o + u.l);
    }

    return {
        type: "message",
        senderID: utils.formatID(md.actorFbId.toString()),
        threadID: utils.formatID((md.threadKey.threadFbId || md.threadKey.otherUserFbId).toString()),
        messageID: md.messageId,
        args: (delta.body || "").trim().split(/\s+/),
        body: delta.body || "",
        attachments: (delta.attachments || []).map(att => utils.formatAttachment(att, att.fb_object || att.original_object || {})),
        mentions,
        timestamp: md.timestamp,
        isGroup: !!md.threadKey.threadFbId,
        participantIDs: delta.participants || md.cid?.canonicalParticipantFbids || []
    };
}

module.exports = function (def, api, ctx, delta, globalCallback) {
    if (ctx.globalOptions.pageID && ctx.globalOptions.pageID !== delta.queue) return;

    (function resolveAttachments(i) {
        const attachments = delta.attachments || [];
        if (i >= attachments.length) {
            let fmtMsg;
            try {
                fmtMsg = formatDeltaMessage(delta);
            } catch (err) {
                return globalCallback({
                    error: "Problem parsing message object.",
                    detail: err,
                    res: delta,
                    type: "parse_error"
                });
            }

            if (ctx.globalOptions.autoMarkDelivery) utils.markDelivery(ctx, api, fmtMsg.threadID, fmtMsg.messageID);
            if (!ctx.globalOptions.selfListen && (fmtMsg.senderID === ctx.i_userID || fmtMsg.senderID === ctx.userID)) return;
            return globalCallback(null, fmtMsg);
        }

        const att = attachments[i];
        if (att.mercury?.attach_type === "photo") {
            api.resolvePhotoUrl(att.fbid, (err, url) => {
                if (!err) att.mercury.metadata.url = url;
                resolveAttachments(i + 1);
            });
        } else {
            resolveAttachments(i + 1);
        }
    })(0);
};