const threadName = require('./lib/event/threadName');
const threadImage = require('./lib/event/threadImage');
const subscribe = require('./lib/event/subscribe');
const unsubscribe = require('./lib/event/unsubscribe');
const approvalQueue = require('./lib/event/approvalQueue');
const activities = require('./lib/event/activities');
const newMessage = require('./lib/message/newMessage');
const ClientPayload = require("./lib/message/ClientPayload");
module.exports = (def, api, ctx, delta, callback) => {
    switch (delta.class) {
        case "ThreadName":
            return threadName(def, api, ctx, delta, callback);
        case "ForcedFetch":
            return threadImage(def, api, ctx, delta, callback);
        case "ParticipantsAddedToGroupThread":
            return subscribe(def, api, ctx, delta, callback);
        case "ParticipantLeftGroupThread":
            return unsubscribe(def, api, ctx, delta, callback);
        case "ApprovalQueue":
            return approvalQueue(def, api, ctx, delta, callback);
        case "AdminTextMessage":
        case "JoinableMode":
            return activities(def, api, ctx, delta, callback);
        case "NewMessage":
            return newMessage(def, api, ctx, delta, callback);
        case "ClientPayload":
            return ClientPayload(def, api, ctx, delta, callback);
        default:
            break;
    }
};
