"use strict";
/**
 * Facebook Messenger Login Module (Custom Rewrite)
 * -----------------------------------------------
 * ✅ Người thực hiện: vtuan
 * ✅ Tham khảo mã nguồn từ: dongdev
 * ✅ Mục tiêu: Viết lại gọn gàng, dễ đọc, dễ bảo trì hơn
 * ✅ Ngày chỉnh sửa: Tháng 7 năm 2025
 *
 * 📩 Hỗ trợ kỹ thuật: https://www.facebook.com/Vtuan.dev
 *
 * ❗Lưu ý: Mã sử dụng appState để đăng nhập Messenger không chính thức.
 *          Dành cho học tập, nghiên cứu. Không khuyến khích dùng vào mục đích thương mại.
 */

const cheerio = require("cheerio");
const log = require("npmlog");
const fs = require("fs");
const utils = require("./helpers");

module.exports = async function login(appState, options = {}, callback) {
  if (typeof options === "function") [callback, options] = [options, {}];
  if (!appState) return callback("Thiếu Appstate, vui lòng kiểm tra lại Appstate!");

  const opts = {
    selfListen: true, listenEvents: true, listenTyping: false,
    updatePresence: false, forceLogin: false, autoMarkDelivery: false,
    autoMarkRead: false, autoReconnect: true, logRecordSize: 100,
    online: false, emitReady: false,
    userAgent: "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/121.0.0.0 Safari/537.36",
    ...options,
  };
  const jar = utils.getJar();
  try {
    const set = (k, v, d = "facebook.com", p = "/") =>
      jar.setCookie(`${k}=${v}; domain=${d}; path=${p};`, "http://" + d);

    typeof appState === "string" ? appState.split(";").forEach(kv => {
      const [k, ...v] = kv.trim().split("="); k && v.length && set(k, v.join("="));
    }) : appState.forEach(c => set(c.key, c.value, c.domain, c.path));
  } catch {
    return callback("AppState không hợp lệ.");
  }

  try {
    const res = await utils.get("https://www.facebook.com/", jar, null, opts, { noRef: true });
    await utils.saveCookies(jar)(res);

    const $ = cheerio.load(res.body);
    let fb_dtsg = $("input[name=\"fb_dtsg\"]").val() || "";

    $("script").each((_, s) => {
      const html = $(s).html() || "";
      const patterns = [
        /"DTSGInitialData",\[\],{"token":"([^"]+)"}/,
        /"DTSGInitData",\[\],{"token":"([^"]+)"}/,
        /"token":"([^"]+)"/,
        /{\\\"token\\\":\\\"([^\\]+)\\\"}/,
        /,{"token":"([^"]+)"},\d+]/,
        /"async_get_token":"([^"]+)"/,
        /"dtsg":{"token":"([^"]+)"/,
        /DTSGInitialData[^>]+>([^<]+)</,
      ];
      for (const p of patterns) {
        const match = html.match(p);
        if (match?.[1]) {
          try {
            fb_dtsg = JSON.parse(match[1].replace(/\\\\"/g, "\""))?.token || match[1];
          } catch {
            fb_dtsg = match[1];
          }
          break;
        }
      }
    });

    const user = jar.getCookies("https://www.facebook.com")
      .find(c => /^(c|i)_user=/.test(c.cookieString()));

    if (!user) return callback("Không tìm thấy cookie người dùng!");

    const userID = user.cookieString().split("=")[1];
    const clientID = (Math.random() * 0x80000000 | 0).toString(16);
    const endpoint = res.body.match(/"endpoint":"([^"]+)"/)?.[1]?.replace(/\\\//g, "/");
    const region = (() => {
      try {
        return endpoint ? new URL(endpoint).searchParams.get("region")?.toUpperCase() : null;
      } catch { return null; }
    })() ?? ["PRN", "PNB", "VLL", "HKG", "SIN"][Math.random() * 5 | 0];

    const ctx = {
      userID, jar, clientID, globalOptions: opts, fb_dtsg,
      access_token: "NONE", clientMutationId: 0, loggedIn: true,
      lastSeqId: res.body.match(/irisSeqID":"([^"]+)"/)?.[1],
      mqttEndpoint: endpoint || `wss://edge-chat.facebook.com/chat?region=prn&sid=${userID}`,
      region, callback_Task: {}, reqCallbacks: {}, firstListen: true,
      req_ID: 0, wsReqNumber: 0, wsTaskNumber: 0, mqttClient: undefined
    };

    const def = utils.makeDefaults(res.body, userID, ctx);
    const api = {
      setOptions: newOpts => Object.assign(opts, newOpts),
      getAppState: () => utils.getAppState(jar),
      postFormData: (url, body) => def.postFormData(url, jar, body),
      getFreshDtsg: async () => {
        try {
          const fresh = await def.get("https://www.facebook.com/", jar, null, opts);
          return cheerio.load(fresh.body)("input[name=\"fb_dtsg\"]").val();
        } catch (e) {
          log.error("getFreshDtsg", e); return null;
        }
      },
      httpPost: (url, form, cb) => {
        def.post(url, jar, form)
          .then(utils.parseAndCheckLogin(ctx, def))
          .then(res => cb(null, res))
          .catch(cb);
      }
    };

    for (const f of fs.readdirSync(__dirname + "/src/").filter(f => f.endsWith(".js"))) {
      const mod = require(`./src/${f}`);
      if (typeof mod === "function") api[f.replace(".js", "")] = mod(def, api, ctx);
      else console.error(`[ERROR] File ${f} không xuất ra hàm`);
    }

    callback(null, api);
  } catch (err) {
    callback(err);
  }
};