module.exports = function ({ api, models }) {
  const Users = require(global.zuckbot.mainPath + "/db/controllers/users")({ models, api })
  const Threads = require(global.zuckbot.mainPath + "/db/controllers/threads")({ models, api })
  const Currencies = require(global.zuckbot.mainPath + "/db/controllers/currencies")({ models });
  const logger = global.loading;
  const fs = require('fs')
  const axios = require("axios");
  (async function () {
    try {
      const [threads, users] = await Promise.all([Threads.getAll(), Users.getAll(['userID', 'name', 'data'])]);
      threads.forEach(data => {
        const idThread = String(data.threadID);
        global.db.allThreadID.push(idThread);
        global.db.threadData.set(idThread, data.data || {});
        global.db.threadInfo.set(idThread, data.threadInfo || {});
      });
      users.forEach(dataU => {
        const idUsers = String(dataU.userID);
        global.db.allUserID.push(idUsers);
        if (dataU.name && dataU.name.length !== 0) {
          global.db.userName.set(idUsers, dataU.name);
        }
      });
    } catch (error) {
      logger(`Can't load environment variable, error: ${error}`);
    }
  })();
  const onRun = require("./onRun")({ api, models, Users, Threads, Currencies });
  const CommandEvent = require("./CommandEvent")({ api, models, Users, Threads, Currencies });
  const onReply = require("./onReply")({ api, models, Users, Threads, Currencies });
  const onReaction = require("./onReaction")({ api, models, Users, Threads, Currencies });
  const onEvent = require("./onEvent")({ api, models, Users, Threads, Currencies });
  const onRefresh = require("./onRefresh")({ api, Threads, Users, Currencies, models });
  const CreateDatabase = require("./CreateDatabase")({ api, Threads, Users, Currencies, models });
  require("./onSchedule.js")({ api, Threads, Users, models });
  return async (event) => {
    if ((event.body || '') && event.senderID != api.getCurrentUserID() && !global.settings.botAdmins.includes(event.senderID)) {
      const thuebotPath = process.cwd() + '/db/databot/thuebot.json';
      const thuebot = JSON.parse(fs.readFileSync(thuebotPath));
      const c = thuebot.find($ => $.t_id == event.threadID);
      if (!c) return;
    }
    if (event.type === "message" || event.type === "message_reply" || event.type === "message_unsend") {
      CreateDatabase({ event });
      onRun({ event });
      onReply({ event });
      CommandEvent({ event });
    } else if (event.type === "change_thread_image") {
    } else if (event.type === "event") {
      onEvent({ event });
      onRefresh({ event });
    } else if (event.type === "message_reaction") {
      let unsend = process.cwd() + "/db/databot/123.json";
      if (!fs.existsSync(unsend)) fs.writeFileSync(unsend, JSON.stringify({}, null, 4));
      let unsendData = JSON.parse(fs.readFileSync(unsend));
      if (!unsendData[event.threadID]) unsendData[event.threadID] = { data: false };
      fs.writeFileSync(unsend, JSON.stringify(unsendData, null, 4));
      if (unsendData[event.threadID].data) api.unsendMessage(event.messageID);
      onReaction({ event });
    } else {
    }
  };
};