module.exports = function ({ Users, Threads, Currencies }) {
    const logger = global.loading;
    return async function ({ event }) {
        const { allUserID, allCurrenciesID, allThreadID, userName, threadInfo } = global.db;
        if (!global.autoCreateDB) return;

        const { senderID, threadID, isGroup } = event;
        const threadIDStr = String(threadID), senderIDStr = String(senderID);

        try {
            // Handle new group threads
            if (isGroup && !allThreadID.includes(threadIDStr)) {
                const threadIn4 = await Threads.getInfo(threadIDStr);
                const dataThread = {
                    threadName: threadIn4.threadName,
                    adminIDs: threadIn4.adminIDs,
                    nicknames: threadIn4.nicknames
                };
                
                allThreadID.push(threadIDStr);
                threadInfo.set(threadIDStr, dataThread);

                await Threads.setData(threadIDStr, { threadInfo: dataThread, data: {} });

                for (const user of threadIn4.userInfo) {
                    const userIDStr = String(user.id);
                    userName.set(userIDStr, user.name);

                    if (!allUserID.includes(userIDStr)) {
                        await Users.createData(userIDStr, { name: user.name, data: {} });
                        allUserID.push(userIDStr);
                        logger(`người dùng mới: ${userIDStr}`, '[ DATABASE ]');
                    }
                }

                logger(`nhóm mới: ${threadIDStr}`, '[ DATABASE ]');
            }

            // Handle new users
            if (!allUserID.includes(senderIDStr) || !userName.has(senderIDStr)) {
                const infoUsers = await Users.getInfo(senderIDStr);
                await Users.createData(senderIDStr, { name: infoUsers.name });
                allUserID.push(senderIDStr);
                userName.set(senderIDStr, infoUsers.name);
                logger(`người dùng mới: ${senderIDStr}`, '[ DATABASE ]');
            }

            // Handle new currencies
            if (!allCurrenciesID.includes(senderIDStr)) {
                await Currencies.createData(senderIDStr, { data: {} });
                allCurrenciesID.push(senderIDStr);
            }
        } catch (err) {
            console.log(err);
        }
    };
};
