module.exports = function ({ api, models, Users, Threads, Currencies }) {
    return function ({ event }) {
        const { onReaction, commands } = global.zuckbot;
        if (onReaction.length === 0) return;
        const indexOfHandle = onReaction.findIndex(e => e.messageID == event.messageID);
        if (indexOfHandle < 0) return;
        if (!commands.get(onReaction[indexOfHandle].name)) {
            api.sendMessage(`Thiếu dữ liệu để có thể thực thi phản hồi lại câu trả lời của bạn`, event.threadID, event.messageID);
            return;
        }
        try {
            commands.get(onReaction[indexOfHandle].name).onReaction({ api, event, models, Users, Threads, Currencies, onReaction: onReaction[indexOfHandle] });
        } catch (error) {
            api.sendMessage(`Đã xảy ra lỗi không mong muốn khi đang thực thi trả lời câu hỏi bạn, lỗi: ${error}`, event.threadID, event.messageID);
        }
    };
};