const stringSimilarity = require('string-similarity');
module.exports = function ({ api, models, Users, Threads, Currencies }) {
    const escapeRegex = (str) => str.replace(/[.*+?^${}()|[\]\\]/g, "\\$&");
    const findCommand = (commandName, commands) => {
        for (let [name, command] of commands) {
            if (name === commandName || (command.zuckbotconfig.aliases && command.zuckbotconfig.aliases.includes(commandName))) {
                return command;
            }
        }
        return null;
    };
    return async function ({ event }) {
        const dateNow = Date.now();
        const { botPrefix, botAdmins } = global.settings;
        const { threadData } = global.db;
        const { commands, cd } = global.zuckbot;
        const { body = 'x', senderID: rawSenderID, threadID: rawThreadID, messageID } = event;
        const senderID = String(rawSenderID);
        const threadID = String(rawThreadID);
        const threadSetting = threadData.get(threadID) || {};
        const prefix = threadSetting.hasOwnProperty("boxPrefix") ? threadSetting.boxPrefix : botPrefix;
        const prefixRegex = new RegExp(`^(<@!?${senderID}>|${escapeRegex(prefix)})\\s*`);
        const send = (msg, callback) => new Promise(r =>
            api.sendMessage(msg, threadID, (err, res) => {
                if (callback) callback(err, res);
                r(res || err);
            },
                messageID
            )
        );
        const uptime = process.uptime();
        const hours = Math.floor(uptime / 3600);
        const minutes = Math.floor((uptime % 3600) / 60);
        const seconds = Math.floor(uptime % 60);
        const [matchedPrefix] = body.match(prefixRegex) || [''];
        let args = body.slice(matchedPrefix.length).trim().split(/ +/);
        let commandName = args.shift().toLowerCase();
        let command = findCommand(commandName, commands);
        if (!prefixRegex.test(body)) {
            args = (body || '').trim().split(/ +/);
            commandName = args.shift()?.toLowerCase();
            command = findCommand(commandName, commands);
            if (command && command.zuckbotconfig) {
                if (command.zuckbotconfig.shadowPrefix === false) {
                    if (commandName.toLowerCase() !== command.zuckbotconfig.name.toLowerCase() && !command.zuckbotconfig.aliases.includes(commandName)) {
                        api.sendMessage(command.zuckbotconfig.name, threadID, messageID);
                        return;
                    }
                } else if (command.zuckbotconfig.shadowPrefix === true && !body.startsWith(botPrefix)) {
                    return;
                }
            }
        }
        if (!command) {
            if (!body.startsWith(prefix)) return;
            const allCommandNames = Array.from(commands.keys()).concat(
                ...Array.from(commands.values()).flatMap(cmd => cmd.zuckbotconfig.aliases || [])
            );
            const bestMatch = stringSimilarity.findBestMatch(commandName, allCommandNames).bestMatch;
            if (bestMatch.rating >= 0.5) {
                command = findCommand(bestMatch.target, commands);
            }
            if (queues.length === 0) {
                return send(`Lệnh gợi ý "${bestMatch.target}"\nupt: ${hours}:${minutes}:${seconds}`);
            } else {
                return send({ body: `Lệnh gợi ý "${bestMatch.target}"\nupt: ${hours}:${minutes}:${seconds}`, attachment: queues.splice(0, 1) });
            }
        }
        if (command) {
            const isAdmin = (await Threads.getInfo(threadID)).adminIDs.some(admin => admin.id === senderID);
            let role = 0;
            if (botAdmins.includes(senderID)) role = 2;
            else if (isAdmin) role = 1;
            if (command.zuckbotconfig.role > 2) command.zuckbotconfig.role = 2;
            if (command.zuckbotconfig.role > role) {
                return api.sendMessage(`Bạn không đủ quyền hạn để sử dụng lệnh ${command.zuckbotconfig.name}`, threadID, messageID);
            }
            if (!cd.has(command.zuckbotconfig.name)) {
                cd.set(command.zuckbotconfig.name, new Map());
            }
            const timestamps = cd.get(command.zuckbotconfig.name);
            const expirationTime = (command.zuckbotconfig.cd || 1) * 1000;
            if (timestamps.has(senderID) && dateNow < timestamps.get(senderID) + expirationTime) {
                return api.sendMessage(`🔄 Vui lòng quay lại sau ${((timestamps.get(senderID) + expirationTime - dateNow) / 1000).toFixed(2)}s`, threadID, messageID);
            }
            const sendVD = (msg, callback) => new Promise(r =>
                api.sendMessage(
                    { body: msg, attachment: queues.splice(0, 1) },
                    threadID,
                    (err, res) => {
                        if (callback) callback(err, res);
                        r(res || err);
                    },
                    messageID
                )
            );
            const box = {
                react: (emoji) => api.setMessageReactionMqtt(emoji, messageID, threadID),
                reply: (msg) => api.sendMessage(msg, threadID, messageID),
                add: (uid) => api.addUserToGroup(uid, threadID),
                kick: (uid) => api.removeUserFromGroup(uid, threadID),
                send: (msg, id) => api.sendMessage(msg, id || threadID),
            };
            const output = (a) => {
                if (typeof a === "object" || Array.isArray(a)) {
                    if (Object.keys(a).length !== 0) a = JSON.stringify(a, null, 4);
                }
                if (typeof a === "number") a.toString();
                return api.sendMessage(a, threadID, messageID);
            };
            try {
                command.onRun({ api, event, args, models, Users, Threads, Currencies, role, send, sendVD, box, output });
                timestamps.set(senderID, dateNow);
            } catch (e) {
                return api.sendMessage(`Đã xảy ra lỗi không mong muốn trong khi thực thi lệnh ${commandName}, lỗi ${e}`, threadID, messageID);
            }
        }
    };
};
