module.exports.zuckbotconfig = {
  name: "theme",
  version: "1.0.0",
  role: 0,
  author: "Choru & TuấnGPT",
  description: "Thay đổi chủ đề đoạn chat hoặc hiển thị danh sách theme",
  Category: "box chat",
  usages: "[list | tên hoặc ID theme]",
  cooldowns: 5,
};

module.exports.onRun = async function({ api, event, args }) {
  const threadID = event.threadID;
  const senderID = event.senderID;
  const input = args.join(" ").trim();

  if (!input) {
    return api.sendMessage("❌ Vui lòng nhập tên theme hoặc 'list' để xem danh sách.", threadID);
  }

  try {
    const result = await api.theme(input, threadID, null, senderID);

    if (Array.isArray(result)) {
      let msg = "🎨 Danh sách các theme có thể dùng:\n\n";
      msg += result
        .map((theme, i) => `${i + 1}. ${theme.name} (${theme.id})`)
        .join("\n");

      return api.sendMessage(msg, threadID);
    }

    return api.sendMessage(`✅ Đã đổi theme của đoạn chat thành: ${result.themeName}`, threadID);
  } catch (err) {
    return api.sendMessage(`❌ Lỗi khi xử lý: ${err.message}`, threadID);
  }
};