this.zuckbotconfig = {
  name: "catbox",
  version: '2.3.1.2',
  author: "Nguyễn Thanh Tuấn",
  role: 0,
  aliases: ['upcat'],
  info: "up ảnh, gif, mp3",
  Category: "Tiện ích",
  usePrefix: false,
  cd: 0,
  shadowPrefix: false,
  image : []
};

this.onRun = async ({ api, event, args }) => {
  const axios = require('axios');
  const FormData = require('form-data');

  if (!event.messageReply || !event.messageReply.attachments || event.messageReply.attachments.length === 0) {
    return api.sendMessage('Bạn chưa gửi ảnh, gif, mp3!', event.threadID, event.messageID);
  }

  const attachments = event.messageReply.attachments;
  const links = [];

  for (const attachment of attachments) {
    const validTypes = ['photo', 'video', 'audio', 'animated_image'];
    if (!validTypes.includes(attachment.type)) continue;

    const url = attachment.url;
    const response = await axios.get(url, { responseType: 'arraybuffer' });
    const buffer = Buffer.from(response.data, 'binary');

    const form = new FormData();
    form.append('reqtype', 'fileupload');
    form.append('userhash', '');
    form.append('fileToUpload', buffer, {
      filename: `upload.${attachment.type === 'photo' ? 'png' : 
                 attachment.type === 'animated_image' ? 'gif' : 
                 attachment.type === 'video' ? 'mp4' : 'mp3'}`
    });

    const uploadResponse = await axios.post('https://catbox.moe/user/api.php', form, {
      headers: form.getHeaders()
    });

    const data = uploadResponse.data;
    if (data.startsWith('Error:')) {
      return api.sendMessage('Có lỗi xảy ra khi up ảnh: ' + data, event.threadID, event.messageID);
    }

    links.push(data);
  }

  if (links.length === 0) {
    return api.sendMessage('Không có đính kèm nào là ảnh, gif, mp3!', event.threadID, event.messageID);
  }

  return api.sendMessage('Đây là các link ảnh, gif, mp3 của bạn:\n' + links.join('\n'), event.threadID, event.messageID);
};