this.zuckbotconfig = {
    name: "help",
    version: '2.3.1.2',
    author: "Nguyễn Thanh Tuấn",
    role: 0,
    info: "Xem danh sách lệnh và info",
    Category: "Tiện ích",
    image: [],
    shadowPrefix: false,
    cd: 5
};
const axios = require("axios");

this.onRun = async function ({ api, event, args }) {
    const { threadID: tid, messageID: mid, senderID: sid } = event;
    var type = !args[0] ? "" : args[0].toLowerCase();
    var msg = "", array = [], i = 0;
    const cmds = global.zuckbot.commands;
    const TIDdata = global.db.threadData.get(tid) || {};
    const admin = settings.botAdmins;
    const NameBot = settings.NameBots;
    var prefix = TIDdata.boxPrefix || global.settings.botPrefix;

    if (type == "all") {
        for (const cmd of cmds.values()) {
            msg += `${++i}. ${cmd.zuckbotconfig.name}\n→ Mô tả: ${cmd.zuckbotconfig.info}\n────────────────\n`;
        }
        return api.sendMessage(msg, tid, mid);
    }

    if (type) {
        for (const cmd of cmds.values()) {
            array.push(cmd.zuckbotconfig.name.toString());
        }
        if (!array.find(n => n == args[0].toLowerCase())) {
            const stringSimilarity = require('string-similarity');
            const commandName = args.shift().toLowerCase() || "";
            var allCommandName = []; 
            const commandValues = cmds.keys();
            for (const cmd of commandValues) allCommandName.push(cmd);
            const checker = stringSimilarity.findBestMatch(commandName, allCommandName);
            if (checker.bestMatch.rating >= 0.5) {
                const command = cmds.get(checker.bestMatch.target);
                if (!command) {
                    msg = `Không tìm thấy lệnh '${type}' trong hệ thống.\n➝ Lệnh gần giống được tìm thấy '${checker.bestMatch.target}' nhưng không tồn tại.`;
                    return api.sendMessage(msg, tid, mid);
                }
                msg = `Không tìm thấy lệnh '${type}' trong hệ thống.\n➝ Lệnh gần giống được tìm thấy '${checker.bestMatch.target}'`;
                return api.sendMessage(msg, tid, mid);
            }
        }
        const cmd = cmds.get(type);
        if (!cmd) {
            msg = `Không tìm thấy lệnh '${type}' trong hệ thống.`;
            return api.sendMessage(msg, tid, mid);
        }
        const cmdConfig = cmd.zuckbotconfig;
        let image = [];
        for (const i of cmdConfig.image) {
            const stream = (await axios.get(i, { responseType: "stream" })).data;
            image.push(stream);
        }
        api.sendMessage({
            body: `[ HƯỚNG DẪN SỬ DỤNG ]\n────────────────\n→ Tên lệnh: ${cmdConfig.name}\n→ Phiên bản: ${cmdConfig.version}\n→ Quyền Hạn: ${cmdConfig.role == 0 ? "Thành Viên" : cmdConfig.role == 1 ? "Quản Trị Viên" : cmdConfig.role = 2 ? "Admin Bot" : "Toàn Quyền"}\n→ Mô Tả: ${cmdConfig.info}\n→ Nhóm: ${cmdConfig.Category}\n→ Cooldowns: ${cmdConfig.cd}s`, attachment: image
        }, tid, mid);
    } else {
        CmdCategory();
        array.sort(S("nameModule"));
        for (const cmd of array) {
            msg += `[ ${cmd.cmdCategory.toUpperCase()} ]\n→ Tổng lệnh: ${cmd.nameModule.length} lệnh\n${cmd.nameModule.join(", ")}\n────────────────\n`;
        }
        msg += `→ Tổng số lệnh: ${cmds.size} lệnh\n→ Tổng số admin bot: ${admin.length}\n→ Tên Bot: ${NameBot}\n${prefix}help + tên lệnh để xem chi tiết\n${prefix}help + all để xem tất cả lệnh`;
        api.sendMessage(msg, tid, mid);
    }

    function CmdCategory() {
        for (const cmd of cmds.values()) {
            const { Category, role, name: nameModule } = cmd.zuckbotconfig;
            if (!array.find(i => i.cmdCategory == Category)) {
                array.push({
                    cmdCategory: Category,
                    permission: role,
                    nameModule: [nameModule]
                });
            } else {
                const find = array.find(i => i.cmdCategory == Category);
                find.nameModule.push(nameModule);
            }
        }
    }
}

function S(k) {
    return function (a, b) {
        let i = 0;
        if (a[k].length > b[k].length) {
            i = 1;
        } else if (a[k].length < b[k].length) {
            i = -1;
        }
        return i * -1;
    }
}
