const axios = require('axios'), FormData = require('form-data');
exports.zuckbotconfig = {
  name: 'imgur',
  version: '2.3.1.2',
  author: "Nguyễn Thanh Tuấn",
  role: 0,
  info: 'cc up vào cl',
  Category: 'Tiện ích',
  usages: '[reply photo/video]',
  cd: 3,
  shadowPrefix: false,
  image: []
};

exports.onRun = async (o) => {
  const send = msg => o.api.sendMessage(msg, o.event.threadID, o.event.messageID);

  let result = [];

  for (let url of (o.event.messageReply?.attachments || o.args)) {
    try {
      const response = await uploadToImgur(url.url || url);
      result.push(response);
    } catch (error) {
      console.error(error);
    }
  }

  send(JSON.stringify(result, 0, 4));
};

async function uploadToImgur(url) {
  try {
    let response = await axios.get(url, { responseType: 'arraybuffer' });
    let data = Buffer.from(response.data);
    let type = /(\.|)mp4/.test(url) ? 'video' : 'image';

    const formData = new FormData();
    formData.append(type, data, {
      filename: 'file',
      contentType: 'image/jpeg',
    });

    const headers = {
      Authorization: 'Client-ID d4741d5c42fd5d0', // thay key tại đây
      ...formData.getHeaders(),
    };

    const uploadResponse = await axios.post('https://api.imgur.com/3/upload', formData, { headers });

    return uploadResponse.data.data.link || uploadResponse.data;
  } catch (error) {
    return error;
  }
}
// nứng quá aaaaaaaaaa