const puppeteer = require("puppeteer");
const fs = require("fs");

module.exports.zuckbotconfig = {
  name: "screenshot",
  version: '2.3.1.2',
  author: "Nguyễn Thanh Tuấn",
  role: 2,
  info: "chụp web",
  Category: "Tiện ích",
  shadowPrefix: false,
  cd: 0
};

module.exports.onRun = async function ({ api, event, args }) {
  const url = args[0];
  const width = args[1] || 1280;
  const height = args[2] || 720;
  const savePath = `${__dirname}/cache/web-${event.senderID}.png`;

  if (isNaN(parseInt(width)) || isNaN(parseInt(height))) {
    return api.sendMessage("ngu", event.threadID, event.messageID);
  }

  if (!url.startsWith("http")) {
    return api.sendMessage("ngux3", event.threadID, event.messageID);
  }

  try {
    await screenshotWebsite(width, height, url, savePath);
    return api.sendMessage({
      body: `ảnh nè`,
      attachment: fs.createReadStream(savePath)
    }, event.threadID, event.messageID);
  } catch (error) {
    return api.sendMessage(error.message, event.threadID, event.messageID);
  }
};

async function screenshotWebsite(width, height, url, path) {
  try {
    const browser = await puppeteer.launch({ headless: true, defaultViewport: null });
    const page = await browser.newPage();
    await page.setViewport({ width: parseInt(width), height: parseInt(height) });
    await page.goto(url, {
      timeout: 15000,
      waitUntil: ["load", "domcontentloaded"],
    });
    await new Promise(resolve => setTimeout(resolve, 2000)); // Alternative to page.waitForTimeout
    await page.screenshot({ path, fullPage: width === 0 || height === 0 });
    await browser.close();
  } catch (error) {
    throw new Error(`Failed to take screenshot: ${error.message}`);
  }
}
