module.exports.zuckbotconfig = {
	name: "setprefix",
  version: '2.3.1.2',
  author: "Nguyễn Thanh Tuấn",
	role: 1,
	info: "Đặt lại prefix của nhóm",
	Category: "QTV",
	usages: "[prefix/reset]",
	shadowPrefix: false,
	cd: 5
};
module.exports.onEvent = async ({ api, event, Threads }) => {
  if (!event.body) return;
  var { threadID, messageID } = event;
  if (event.body.toLowerCase() == "prefix")  {
    const threadSetting = (await Threads.getData(String(threadID))).data || {};
    const prefix = (threadSetting.hasOwnProperty("boxPrefix")) ? threadSetting.boxPrefix : global.settings.botPrefix;

    api.sendMessage(`Prefix của hệ thống: ${global.settings.botPrefix}\nPrefix của nhóm bạn: ${prefix}`,threadID, messageID);
  }
}
module.exports.onReaction = async function({ api, event, Threads, onReaction }) {
	try {
		if (event.userID != onReaction.author) return;
		const { threadID, messageID } = event;
		var data = (await Threads.getData(String(threadID))).data || {};
		data["boxPrefix"] = onReaction.PREFIX;
		await Threads.setData(threadID, { data });
		await global.db.threadData.set(String(threadID), data);
		api.unsendMessage(onReaction.messageID);

    api.changeNickname(`[ ${onReaction.PREFIX} ] • ${global.settings.NameBots}`,event.threadID, api.getCurrentUserID());
    
		return api.sendMessage(`✅ Đã chuyển đổi prefix của nhóm thành: ${onReaction.PREFIX}`, threadID, messageID);
    
	} catch (e) { return console.log(e) }
}
module.exports.onRun = async ({ api, event, args, Threads }) => {
    if (!args || args.length === 0 || !args[0].trim()) {
        return api.sendMessage('❎ Phần prefix cần đặt không được để trống', event.threadID, event.messageID);
    }
    let prefix = args[0].trim();
    if (prefix === "reset") {
        var data = (await Threads.getData(event.threadID)).data || {};
        data["boxPrefix"] = global.settings.botPrefix;
        await Threads.setData(event.threadID, { data });
        await global.db.threadData.set(String(event.threadID), data);
        api.changeNickname(`[ ${global.settings.botPrefix} ] • ${global.settings.NameBots}`, event.threadID, api.getCurrentUserID());
        return api.sendMessage(`✅ Đã reset prefix về mặc định: ${global.settings.botPrefix}`, event.threadID, event.messageID);
    } else {
        return api.sendMessage(`Bạn muốn đổi prefix thành: ${prefix}\nThả cảm xúc để xác nhận`, event.threadID, (error, info) => {
            global.zuckbot.onReaction.push({
                name: this.zuckbotconfig.name,
                messageID: info.messageID,
                author: event.senderID,
                PREFIX: prefix
            });
        });
    }
};
