module.exports = function ({ models }) {
const Currencies = models.use('Currencies');
  async function getAll(...data) {
    var where, attributes;
    for (const i of data) {
      if (typeof i != 'object') throw `Phải là một Array hoặc Object hoặc có thể là cả hai`
      if (Array.isArray(i)) attributes = i;
      else where = i;
    }
    try { return (await Currencies.findAll({ where, attributes })).map(e => e.get({ plain: true })) }
    catch (error) {
      console.error(error);
      throw new Error(error);
    };
  }
  async function getData(userID) {
    try {
      const data = await Currencies.findOne({ where: { userID }});
      if (data) return data.get({ plain: true });
      else return false;
    } 
    catch (error) {
      console.error(error);
      throw new Error(error);
    };
  }
  async function setData(userID, options = {}) {
    if (typeof options != 'object' && !Array.isArray(options)) throw `Phải là một Object`
    try {
      (await Currencies.findOne({ where: { userID } })).update(options);
      return true;
    } 
    catch (error) {
      console.error(error);
      throw new Error(error);
    }
  }
  async function delData(userID) {
    try {
      (await Currencies.findOne({ where: { userID } })).destroy();
      return true;
    }
    catch (error) {
      console.error(error);
      throw new Error(error);
    }
  }
  async function createData(userID, defaults = {}) {
    if (typeof defaults != 'object' && !Array.isArray(defaults)) throw "Phải là một Array hoặc Object hoặc có thể là cả hai";
    try {
      await Currencies.findOrCreate({ where: { userID }, defaults });
      return true;
    }
    catch (error) {
      console.error(error);
      throw new Error(error);
    }
  }
  async function increaseCoins(userID, coins) {
    if (typeof coins != 'number') throw "Phải là một Object";
    try {
      let balance = (await getData(userID)).coins;
      await setData(userID, { coins: balance + coins });
      return true;
    }
    catch (error) {
      console.error(error);
      throw new Error(error);
    }
  }
  async function decreaseCoins(userID, coins) {
    if (typeof coins != 'number') throw "Phải là một con số";
    try {
      let balance = (await getData(userID)).coins;
      if (balance < coins) return false;
      await setData(userID, { coins: balance - coins });
      return true;
    } catch (error) {
      console.error(error);
      throw new Error(error);
    }
  }
  return {
    getAll,
    getData,
    setData,
    delData,
    createData,
    increaseCoins,
    decreaseCoins
  };
};