import { ChatInputCommandInteraction, Message } from "discord.js";
import { commands } from "../index";

export default {
  data: {
    name: "help",
    description: "Hiển thị danh sách lệnh có sẵn.",
    toJSON() {
      return {
        name: "help",
        description: "Hiển thị danh sách lệnh có sẵn.",
      };
    },
  },
  ownersOnly: false,
  async execute(input: ChatInputCommandInteraction | Message) {
    const commandList = commands
      .map((cmd) => `- \`${cmd.data.name}\`: ${cmd.data.description}`)
      .join("\n");

    const replyText = `📜 **Danh sách lệnh:**\n${commandList}`;

    if (input instanceof Message) {
      await input.reply(replyText);
    } else {
      await input.reply({ content: replyText, ephemeral: true });
    }
  },
};