import { Message, EmbedBuilder } from 'discord.js';
import { MusicQueue } from '../utils/MusicQueue';
import { queues } from '../index';
import type { Command } from '../types';

export default <Command>{
  data: {
    name: 'skip',
    description: 'Skip the current song',
    toJSON() {
      return { name: 'skip', description: 'Skip the current song' };
    },
  },
  ownersOnly: false,
  async execute(message: Message) {
    const guildId = message.guild?.id;
    if (!guildId) return message.reply('❌ This command can only be used in a server.');

    const queue = queues.get(guildId);
    if (!queue || !queue.playing || !queue.currentSong) {
      return message.reply('❌ No song is currently playing!');
    }

    queue.player.stop();

    const embed = new EmbedBuilder()
      .setColor('#ff9900')
      .setTitle('⏭️ Song Skipped')
      .setDescription(`Skipped: **${queue.currentSong.title}**`);

    await message.reply({ embeds: [embed] });
  },
};