import { Message, EmbedBuilder } from 'discord.js';
import { MusicQueue } from '../utils/MusicQueue';
import { queues } from '../index';
import type { Command } from '../types';

export default <Command>{
  data: {
    name: 'stop',
    description: 'Stop playing and clear the queue',
    toJSON() {
      return { name: 'stop', description: 'Stop playing and clear the queue' };
    },
  },
  ownersOnly: false,
  async execute(message: Message) {
    const guildId = message.guild?.id;
    if (!guildId) return message.reply('❌ This command can only be used in a server.');

    const queue = queues.get(guildId);
    if (!queue || !queue.playing) {
      return message.reply('❌ No music is currently playing!');
    }

    queue.songs = [];
    queue.playing = false;
    queue.currentSong = null;
    queue.player.stop();
    if (queue.connection) {
      queue.connection.destroy();
      queue.connection = null;
    }

    const embed = new EmbedBuilder()
      .setColor('#ff0000')
      .setTitle('⏹️ Music Stopped')
      .setDescription('Stopped playing and cleared the queue.');

    await message.reply({ embeds: [embed] });
  },
};