function [RES1,RES3,AUCS,nu] = BEST_NU_EC( z_test,Z_train,Xtest,Ytest,Xtrain,Ytrain,LabelsTest,GRID)
%UNTITLED6 Summary of this function goes here
%   Detailed explanation goes here

if ~exist('GRID','var')
    GRID = [];
end

if isempty(GRID)
    nu = logspace(-1,4,30);
else
    nu = GRID.nus;
end

[~, d]=size(Xtest);


Czz       = inv(cov(Z_train));
Cxx       = inv(cov(Xtrain));
Cyy       = inv(cov(Ytrain));

A_RX_ec   = zeros(30,1);
A_YX_ec   = zeros(30,1);
A_XY_ec   = zeros(30,1);
A_HACD_ec = zeros(30,1);

AUX_Z  = sum((z_test*Czz).*z_test,2);
AUX_X  = sum((Xtest *Cxx).*Xtest,2);
AUX_Y  = sum((Ytest *Cyy).*Ytest,2);

LabelsTest = logical(LabelsTest');
for i = 1:length(nu)
    
    A_z_log_ec =(2*d+nu(i)) * log(1+AUX_Z/(nu(i)));
    A_x_log_ec =(d+nu(i))   * log(1+AUX_X/(nu(i)));
    A_y_log_ec =(d+nu(i))   * log(1+AUX_Y/(nu(i)));
    
    
    A_RX_log_ec   = A_z_log_ec;
    A_YX_log_ec   = A_z_log_ec - A_y_log_ec;
    A_XY_log_ec   = A_z_log_ec - A_x_log_ec;
    A_HACD_log_ec = A_z_log_ec - A_x_log_ec - A_y_log_ec;
    
    
%     [~, ~, ~, A_RX_ec(i)]   = perfcurve(LabelsTest,A_RX_log_ec,1);
%     [~ ,~, ~, A_YX_ec(i)]   = perfcurve(LabelsTest,A_YX_log_ec,1);
%     [~ ,~ ,~, A_XY_ec(i)]   = perfcurve(LabelsTest,A_XY_log_ec,1);
%     [~, ~, ~, A_HACD_ec(i)] = perfcurve(LabelsTest,A_HACD_log_ec,1);
    
    A_RX_ec(i)   = fastAUC(LabelsTest,A_RX_log_ec);
    A_YX_ec(i)   = fastAUC(LabelsTest,A_YX_log_ec);
    A_XY_ec(i)   = fastAUC(LabelsTest,A_XY_log_ec);
    A_HACD_ec(i) = fastAUC(LabelsTest,A_HACD_log_ec);
    
end


[AUC_RX,ind_nu_RX]     = max(A_RX_ec);
[AUC_YX,ind_nu_YX]     = max(A_YX_ec);
[AUC_XY,ind_nu_XY]     = max(A_XY_ec);
[AUC_HACD,ind_nu_HACD] = max(A_HACD_ec);

RES1                   = [AUC_RX,AUC_YX,AUC_XY,AUC_HACD];
RES3                   = [nu(ind_nu_RX),nu(ind_nu_YX),nu(ind_nu_XY),nu(ind_nu_HACD)];

AUCS.A_RX_ec = A_RX_ec;
AUCS.A_YX_ec = A_YX_ec;
AUCS.A_XY_ec = A_XY_ec;
AUCS.A_HACD_ec = A_HACD_ec;
end

