function [Xtrain, Ytrain, Xtest, Ytest, LabelsTest] = TrainTestData(XVector,YVector,numTest,numTrain,Labels,SSS)

%  QUE HACE:
%
%   Selecciona p�xeles para entrenar y testear el metodo de ACD correspondiente
%
% INPUTS:
%
%
%   XVector         : Vector imagen original (antes de cambios)
%
%   YVector         : Vector imagen con cambios
%
%   numTest         : Numero de pixeles para testear el detector
%
%   numTrain        : Numero de pixeles para entrenar el detector
%
%   Labels          :  Vector con la posicion de los pixeles de cambio
%                        (1 = cambio) (0 = No cambio)
%
% OUTPUTS
%
%   Xtrain
%
%   Ytrain
%
%   Xtest
%
%   Ytest
%
%   LabelsTest



if ~exist('SSS')
    
    SSS = 1234;
    
end

rand('seed',SSS);
randn('seed',SSS);

xx= mean(XVector);
Xm= XVector-repmat(xx,size(XVector,1),1);
std_x = std(XVector);
Xstd = repmat(std_x,size(XVector,1),1);
XVector = Xm./Xstd;

yy= mean(YVector);
Ym = YVector - repmat(yy,size(YVector,1),1);
std_y = std(YVector);
Ystd = repmat(std_y,size(YVector,1),1);
YVector = Ym./Ystd;

[n , ~] = size(XVector);

r     = randperm(n);
t     = numTrain;  % train examples
m     = numTest;  % test examples

Xtest = XVector(r(1:m),:); % select the test ones
Ytest = YVector(r(1:m),:);

Xtrain = XVector(r(m+1:m+t),:); % the remainder for training
Ytrain = YVector(r(m+1:m+t),:);


LabelsTest = Labels(r(1:m));





