




function[AUC_KRX_rbf,AUC_KYX_rbf,AUC_KXY_rbf,AUC_KHACD_rbf,opt,opt2,l,MEDIAS]= best_parameters_KEC_ACD(z_test,Z_train,Xtrain,Ytrain,Xtest,Ytest,LabelsTest,GRID)

d = size(Xtrain,2);

if ~exist('GRID','var')
    GRID = [];
end

if isempty(GRID)
    
    opt  = [0 logspace(-1,4,50)];    
    opt2 = logspace(-1,4,30);
    l    = [1e-1,1e-2,1e-3,1e-4,1e-5,1e-6];
    
    AUC_KRX_rbf = zeros(length(opt),length(opt2),length(l));
    AUC_KYX_rbf = zeros(length(opt),length(opt2),length(l));
    AUC_KXY_rbf = zeros(length(opt),length(opt2),length(l));
    AUC_KHACD_rbf = zeros(length(opt),length(opt2),length(l));
    
else
    opt  = GRID.roscas;
    opt2 = GRID.nus;
    l    = GRID.lambdas;
    
    AUC_KRX_rbf = zeros(length(opt),length(opt2),length(l));
    AUC_KYX_rbf = zeros(length(opt),length(opt2),length(l));
    AUC_KXY_rbf = zeros(length(opt),length(opt2),length(l));
    AUC_KHACD_rbf = zeros(length(opt),length(opt2),length(l));
    
end

MEDIAS = [mean(pdist(Z_train)) mean(pdist(Xtrain)) mean(pdist(Ytrain))];


%   NU optimo vs SIGMA optima vs Lambda optima

LabelsTest = logical(LabelsTest');
for rosca = 1:length(opt) % rosca
    
    sigma_z = opt(rosca)*MEDIAS(1);
    sigma_x = opt(rosca)*MEDIAS(2);
    sigma_y = opt(rosca)*MEDIAS(3);
    
    
    Kzz_rbf_train_train_aux = kernel2(Z_train,Z_train,sigma_z);
    Kxx_rbf_train_train_aux = kernel2(Xtrain,Xtrain,sigma_x);
    Kyy_rbf_train_train_aux = kernel2(Ytrain,Ytrain,sigma_y);
    
    Kz_rbf_test_train_aux = kernel2(z_test,Z_train,sigma_z);
    Kx_rbf_test_train_aux = kernel2(Xtest,Xtrain,sigma_x);
    Ky_rbf_test_train_aux = kernel2(Ytest,Ytrain,sigma_y);
    
    
    for lambda = 1:length(l);
        
        chi_z = sum(Kz_rbf_test_train_aux*pinv(Kzz_rbf_train_train_aux*Kzz_rbf_train_train_aux + l(lambda)*eye(size(Kzz_rbf_train_train_aux,1))).*Kz_rbf_test_train_aux,2);
        chi_x = sum(Kx_rbf_test_train_aux*pinv(Kxx_rbf_train_train_aux*Kxx_rbf_train_train_aux  + l(lambda)*eye(size(Kxx_rbf_train_train_aux,1))).*Kx_rbf_test_train_aux,2);
        chi_y = sum (Ky_rbf_test_train_aux*pinv(Kyy_rbf_train_train_aux*Kyy_rbf_train_train_aux  + l(lambda)*eye(size(Kyy_rbf_train_train_aux,1))).*Ky_rbf_test_train_aux,2);
        
        
        for nu = 1:length(opt2)
            
            K_EC_RX = (2*d+opt2(nu)) * log(1+chi_z/(opt2(nu)));
            K_EC_YX = (2*d+opt2(nu)) * log(1+chi_z/(opt2(nu))) - (d+opt2(nu))*log(1+chi_y/(opt2(nu)));
            K_EC_XY = (2*d+opt2(nu)) * log(1+chi_z/(opt2(nu))) - (d+opt2(nu))*log(1+chi_x/(opt2(nu)));
            K_EC_HACD = (2*d+opt2(nu)) * log(1+chi_z/(opt2(nu))) - (d+opt2(nu))*log(1+chi_x/(opt2(nu))) - (d+opt2(nu))*log(1+chi_y/(opt2(nu)));
            
%             [~,~,~,AUC_KRX_rbf]   = perfcurve(LabelsTest,K_EC_RX,1);
%             [~,~,~,AUC_KYX_rbf]   = perfcurve(LabelsTest,K_EC_YX,1);
%             [~,~,~,AUC_KXY_rbf]   = perfcurve(LabelsTest,K_EC_XY,1);
%             [~,~,~,AUC_KHACD_rbf] = perfcurve(LabelsTest,K_EC_HACD,1);
            
            AUC_KRX_rbf(rosca,nu,lambda)   = fastAUC(LabelsTest,K_EC_RX);
            AUC_KYX_rbf(rosca,nu,lambda)   = fastAUC(LabelsTest,K_EC_YX);
            AUC_KXY_rbf(rosca,nu,lambda)   = fastAUC(LabelsTest,K_EC_XY);
            AUC_KHACD_rbf(rosca,nu,lambda) = fastAUC(LabelsTest,K_EC_HACD);
            

            
        end
        [rosca lambda]
    end
    
end




%
% Compute a kernel given input data
%
% Inputs:
%         X:  training data (samples in rows, features in columns)
%         X2: test data (samples in rows, features in columns)
%         sigma: vector of sigmas [s_1 s_2 s_3 ...]
% Output:
%         K:  kernel matrix
%

function KK = kernel2(X1, X2, sigma)


K = X1 * X2';

if length(sigma)>1
    X1_row_sq = sum(X1.^2, 2) / 2;
    X2_row_sq = sum(X2.^2, 2) / 2;
    K2 = bsxfun(@minus, K, X1_row_sq);
    K2 = bsxfun(@minus, K2, X2_row_sq');
    for ind_s = 1:length(sigma)
        if sigma(ind_s) == 0
            KK(ind_s).K = K;
        else
            
            KK(ind_s).K = exp(K2 / (2*sigma(ind_s)^2));
            KK(ind_s).sig = sigma(ind_s);
        end
    end
else
    if sigma == 0
        KK = K;
    else
        
        X1_row_sq = sum(X1.^2, 2) / 2;
        X2_row_sq = sum(X2.^2, 2) / 2;
        K2 = bsxfun(@minus, K, X1_row_sq);
        K2 = bsxfun(@minus, K2, X2_row_sq');
        KK = exp(K2 / (2*sigma^2));
%         KK = (1/(sigma*sqrt(2*pi)))*exp(K2 / (2*sigma^2));
    end
end






