



function [AUC_KRX_rbf,AUC_KYX_rbf,AUC_KXY_rbf,AUC_KHACD_rbf,opt,l,MEDIAS]= best_parameters_K_ACD_val(z_test,Z_train,Xtrain,Ytrain,Xtest,Ytest,LabelsTest,GRID)

if ~exist('GRID','var')
    GRID = [];
end

if isempty(GRID)
    
    opt = [0 logspace(-1,4,50)];  % grid cross validation
    l = [1e-1,1e-2,1e-3,1e-4,1e-5,1e-6];  % tuning sigma
    
    AUC_KRX_rbf = zeros(length(opt),length(l));
    AUC_KYX_rbf = zeros(length(opt),length(l));
    AUC_KXY_rbf = zeros(length(opt),length(l));
    AUC_KHACD_rbf = zeros(length(opt),length(l));
else
    opt = GRID.roscas;
    l = GRID.lambdas;
    
    AUC_KRX_rbf = zeros(length(opt),length(l));
    AUC_KYX_rbf = zeros(length(opt),length(l));
    AUC_KXY_rbf = zeros(length(opt),length(l));
    AUC_KHACD_rbf = zeros(length(opt),length(l));
end

MEDIAS = [mean(pdist(Z_train)) mean(pdist(Xtrain)) mean(pdist(Ytrain))];


sigmas_z = opt*MEDIAS(1);
sigmas_x = opt*MEDIAS(2);
sigmas_y = opt*MEDIAS(3);


Kzz_train_train_aux = kernel2(Z_train,Z_train,sigmas_z);
Kxx_train_train_aux = kernel2(Xtrain,Xtrain,sigmas_x);
Kyy_train_train_aux = kernel2(Ytrain,Ytrain,sigmas_y);

Kz_test_train_aux = kernel2(z_test,Z_train,sigmas_z);
Kx_test_train_aux = kernel2(Xtest,Xtrain,sigmas_x);
Ky_test_train_aux = kernel2(Ytest,Ytrain,sigmas_y);
    
LabelsTest = logical(LabelsTest');
for rosca = 1:length(opt)      % tuning sigma
    
    Kzz_train_train = Kzz_train_train_aux(rosca).K;
    Kxx_train_train = Kxx_train_train_aux(rosca).K;
    Kyy_train_train = Kyy_train_train_aux(rosca).K;
    
    
    Kz_test_train = Kz_test_train_aux(rosca).K;
    Kx_test_train = Kx_test_train_aux(rosca).K;
    Ky_test_train = Ky_test_train_aux(rosca).K;
    
    for lambda = 1:length(l);    % tuning lambda
        
        chi_z = sum(Kz_test_train*pinv(Kzz_train_train*Kzz_train_train + l(lambda)*eye(size(Kzz_train_train,1))).*Kz_test_train,2);
        chi_x = sum(Kx_test_train*pinv(Kxx_train_train*Kxx_train_train  + l(lambda)*eye(size(Kxx_train_train,1))).*Kx_test_train,2);
        chi_y = sum (Ky_test_train*pinv(Kyy_train_train*Kyy_train_train  + l(lambda)*eye(size(Kyy_train_train,1))).*Ky_test_train,2);
        
        K_EC_RX = chi_z;
        K_EC_YX = chi_z - chi_y;
        K_EC_XY = chi_z - chi_x;
        K_EC_HACD = chi_z - chi_x - chi_y;
        
        %         [~,~,~,AUC_KRX_rbf]= perfcurve(LabelsTest,K_EC_RX,1);
        %         [~,~,~,AUC_KYX_rbf]= perfcurve(LabelsTest,K_EC_YX,1);
        %         [~,~,~,AUC_KXY_rbf]= perfcurve(LabelsTest,K_EC_XY,1);
        %         [~,~,~,AUC_KHACD_rbf]= perfcurve(LabelsTest,K_EC_HACD,1);
        
        AUC_KRX_rbf(rosca,lambda)   = fastAUC(LabelsTest,K_EC_RX);
        AUC_KYX_rbf(rosca,lambda)   = fastAUC(LabelsTest,K_EC_YX);
        AUC_KXY_rbf(rosca,lambda)   = fastAUC(LabelsTest,K_EC_XY);
        AUC_KHACD_rbf(rosca,lambda) = fastAUC(LabelsTest,K_EC_HACD);
        
        [rosca lambda]
    end
    
end


%
% Compute a kernel given input data
%
% Inputs:
%         X:  training data (samples in rows, features in columns)
%         X2: test data (samples in rows, features in columns)
%         sigma: vector of sigmas [s_1 s_2 s_3 ...]
% Output:
%         K:  kernel matrix
%

function KK = kernel2(X1, X2, sigma)


K = X1 * X2';

if length(sigma)>1
    X1_row_sq = sum(X1.^2, 2) / 2;
    X2_row_sq = sum(X2.^2, 2) / 2;
    K2 = bsxfun(@minus, K, X1_row_sq);
    K2 = bsxfun(@minus, K2, X2_row_sq');
    for ind_s = 1:length(sigma)
        if sigma(ind_s) == 0
            KK(ind_s).K = K;
        else
            
            KK(ind_s).K = exp(K2 / (2*sigma(ind_s)^2));
            KK(ind_s).sig = sigma(ind_s);
        end
    end
else
    if sigma == 0
        KK = K;
    else
        
        X1_row_sq = sum(X1.^2, 2) / 2;
        X2_row_sq = sum(X2.^2, 2) / 2;
        K2 = bsxfun(@minus, K, X1_row_sq);
        K2 = bsxfun(@minus, K2, X2_row_sq');
        KK = exp(K2 / (2*sigma^2));
%         KK = (1/(sigma*sqrt(2*pi)))*exp(K2 / (2*sigma^2));
    end
end





