function  RES = test_ACD_val(Xtrain ,Ytrain ,Xtest ,Ytest,LabelsTest,PARAMS,method)

% USE: 
% RES = test_ACD_val(Xtrain ,Ytrain ,Xtest ,Ytest,LabelsTest,PARAMS,method)
% 
% % inputs:
%            Xtrain :  1ra imagen train , imagen sin anomalia
%            Ytrain :  2da imagen train, imagen con la anomalia
%            Xtest :  1ra imagen test , imagen sin anomalia
%            Ytest :  2da imagen test, imagen con la anomalia
%
%            Labels     : Etiquetas de las anomalias
%
%            method (string): RX, YX, XY, HACD, EC_RX, EC_YX, EC_XY, EC_HACD ...
%                      K_RX, K_YX, K_XY, K_HACD, K_EC_RX, K_EC_YX, K_EC_XY, K_EC_HACD
% % Outputs: 
%
%
%
% PARAMS :     PARAMS.nu: parametro del detector eliptico
%              PARAMS.sigma: paramtro del kernel rbf
%              PARAMS.lambda: parametro de la regularizacion

if strcmpi('EC',method(1:2))
    eval(['nu = PARAMS.nu_' method(4:end) ';'])
    
elseif strcmpi('K_EC_RX',method) || strcmpi('K_EC_YX',method) || strcmpi('K_EC_XY',method) || strcmpi('K_EC_HACD',method)
    eval(['nu = PARAMS.' method(6:end) '_nu;'])
    eval(['rosca = PARAMS.' method(6:end) '_rosca;'])
    eval(['lambda = PARAMS.' method(6:end) '_lambda;'])

elseif strcmpi('K_RX',method) || strcmpi('K_YX',method) || strcmpi('K_XY',method) || strcmpi('K_HACD',method)
    eval(['rosca = PARAMS.' method(3:end) '_rosca;'])
    eval(['lambda = PARAMS.' method(3:end) '_lambda;'])    
end


[~,d]=size(Xtest);


Z_train = [Xtrain Ytrain];
Z_test  = [Xtest Ytest];

if ~strcmp(method(1),'K')
    
    Czz = inv(cov(Z_train));
    Cxx = inv(cov(Xtrain));
    Cyy = inv(cov(Ytrain));
    
    
    Az = sum(Z_test*Czz.*Z_test,2);
    Ax = sum(Xtest*Cxx.*Xtest,2);
    Ay = sum(Ytest*Cyy.*Ytest,2);
    
    TIPO = method;
    
else
    
    sigmax = rosca*mean(pdist(Xtrain));
    sigmay = rosca*mean(pdist(Ytrain));
    sigmaz = rosca*mean(pdist(Z_train));
    
    Kz_test = kernel2(Z_test,Z_train,sigmaz);
    Kz_train = kernel2(Z_train,Z_train,sigmaz);
    
    Kx_test = kernel2(Xtest,Xtrain,sigmax);
    Kx_train = kernel2(Xtrain,Xtrain,sigmax);
    
    Ky_test = kernel2(Ytest,Ytrain,sigmay);
    Ky_train = kernel2(Ytrain,Ytrain,sigmay);
    
    Az = sum(Kz_test*pinv(Kz_train*Kz_train + lambda*eye(size(Kz_train,1))).*Kz_test,2);
    Ay = sum(Ky_test*pinv(Ky_train*Ky_train + lambda*eye(size(Ky_train,1))).*Ky_test,2);
    Ax = sum(Kx_test*pinv(Kx_train*Kx_train + lambda*eye(size(Kx_train,1))).*Kx_test,2);
    
    TIPO = method(3:end);
end


if strcmpi('RX',TIPO)
    A = Az;
elseif strcmpi('YX',TIPO)
    A = Az - Ay;
elseif strcmpi('XY',TIPO)
    A = Az - Ax; 
elseif strcmpi('HACD',TIPO)
    A = Az - Ax - Ay;
elseif strcmpi('EC_RX',TIPO)
    A = (2*d+nu) * log(1+Az/(nu));
elseif strcmpi('EC_YX',TIPO)
    A = (2*d+nu) * log(1+Az/(nu)) - (d+nu)*log(1+Ay/(nu));
elseif strcmpi('EC_XY',TIPO)
    A = (2*d+nu) * log(1+Az/(nu)) - (d+nu)*log(1+Ax/(nu));
elseif strcmpi('EC_HACD',TIPO)
    A = (2*d+nu) * log(1+Az/(nu)) - (d+nu)*log(1+Ax/(nu)) - (d+nu)*log(1+Ay/(nu));
end

[FP,TP,T,AUC]   = perfcurve(LabelsTest,A,1);


RES.AUC          = AUC;
RES.FP           = FP;
RES.TP           = TP;
RES.T            = T;
RES.Label_pred   = A;
RES.method       = method;




%
% Compute a kernel given input data
%
% Inputs:
%         X:  training data (samples in rows, features in columns)
%         X2: test data (samples in rows, features in columns)
%         sigma: vector of sigmas [s_1 s_2 s_3 ...]
% Output:
%         K:  kernel matrix
%

function KK = kernel2(X1, X2, sigma)


K = X1 * X2';

if length(sigma)>1
    X1_row_sq = sum(X1.^2, 2) / 2;
    X2_row_sq = sum(X2.^2, 2) / 2;
    K2 = bsxfun(@minus, K, X1_row_sq);
    K2 = bsxfun(@minus, K2, X2_row_sq');
    for ind_s = 1:length(sigma)
        if sigma(ind_s) == 0
            KK(ind_s).K = K;
        else
            
            KK(ind_s).K = exp(K2 / (2*sigma(ind_s)^2));
            KK(ind_s).sig = sigma(ind_s);
        end
    end
else
    if sigma == 0
        KK = K;
    else
        
        X1_row_sq = sum(X1.^2, 2) / 2;
        X2_row_sq = sum(X2.^2, 2) / 2;
        K2 = bsxfun(@minus, K, X1_row_sq);
        K2 = bsxfun(@minus, K2, X2_row_sq');
        KK = exp(K2 / (2*sigma^2));
%         KK = (1/(sigma*sqrt(2*pi)))*exp(K2 / (2*sigma^2));
    end
end








