




function[RES_BAR1,RES_BAR2,RES_BAR3,RES_BAR4,opt,opt2,l,MEDIAS]= test_K_ACD(z_test,Z_train,Xtrain,Ytrain,Xtest,Ytest,LabelsTest,PARAMS)

d = size(Xtrain,2);

MEDIAS = [mean(pdist(Z_train)) mean(pdist(Xtrain)) mean(pdist(Ytrain))];


%   NU optimo vs SIGMA optima vs Lambda optima
rrr = PARAMS.RX_rosca;
lll = PARAMS.RX_lambda;

sigma_z = rrr*MEDIAS(1);
sigma_x = rrr*MEDIAS(2);
sigma_y = rrr*MEDIAS(3);

Kzz_rbf_train_train = kernel2(Z_train,Z_train,sigma_z);
Kxx_rbf_train_train = kernel2(Xtrain,Xtrain,sigma_x);
Kyy_rbf_train_train = kernel2(Ytrain,Ytrain,sigma_y);

Kz_rbf_test_train = kernel2(z_test,Z_train,sigma_z);
Kx_rbf_test_train = kernel2(Xtest,Xtrain,sigma_x);
Ky_rbf_test_train = kernel2(Ytest,Ytrain,sigma_y);

        
chi_z = sum(Kz_rbf_test_train*pinv(Kzz_rbf_train_train*Kzz_rbf_train_train + lll*eye(size(Kzz_rbf_train_train,1))).*Kz_rbf_test_train,2);
chi_x = sum(Kx_rbf_test_train*pinv(Kxx_rbf_train_train*Kxx_rbf_train_train  + lll*eye(size(Kxx_rbf_train_train,1))).*Kx_rbf_test_train,2);
chi_y = sum (Ky_rbf_test_train*pinv(Kyy_rbf_train_train*Kyy_rbf_train_train  + lll*eye(size(Kyy_rbf_train_train,1))).*Ky_rbf_test_train,2);
        
K_EC_RX = chi_z;
K_EC_YX = chi_z - chi_y;
K_EC_XY = chi_z - chi_x;
K_EC_HACD = chi_z - chi_x - chi_y;

[~,~,~,AUC_KRX_rbf]= perfcurve(LabelsTest,K_EC_RX,1);
[~,~,~,AUC_KYX_rbf]= perfcurve(LabelsTest,K_EC_YX,1);
[~,~,~,AUC_KXY_rbf]= perfcurve(LabelsTest,K_EC_XY,1);
[~,~,~,AUC_KHACD_rbf]= perfcurve(LabelsTest,K_EC_HACD,1);


RES.AUC_RX = AUC_KRX_rbf;
RES.AUC_YX = AUC_KYX_rbf;
RES.AUC_XY = AUC_KXY_rbf;
RES.AUC_HACD = AUC_KHACD_rbf;

        
        
        

%
% Compute a kernel given input data
%
% Inputs:
%         X:  training data (samples in rows, features in columns)
%         X2: test data (samples in rows, features in columns)
%         sigma: vector of sigmas [s_1 s_2 s_3 ...]
% Output:
%         K:  kernel matrix
%

function KK = kernel2(X1, X2, sigma)


K = X1 * X2';

if length(sigma)>1
    X1_row_sq = sum(X1.^2, 2) / 2;
    X2_row_sq = sum(X2.^2, 2) / 2;
    K2 = bsxfun(@minus, K, X1_row_sq);
    K2 = bsxfun(@minus, K2, X2_row_sq');
    for ind_s = 1:length(sigma)
        if sigma(ind_s) == 0
            KK(ind_s).K = K;
        else
            
            KK(ind_s).K = (1/(sigma(ind_s)*sqrt(2*pi)))*exp(K2 / (2*sigma(ind_s)^2));
            KK(ind_s).sig = sigma(ind_s);
        end
    end
else
    if sigma == 0
        KK = K;
    else
        
        X1_row_sq = sum(X1.^2, 2) / 2;
        X2_row_sq = sum(X2.^2, 2) / 2;
        K2 = bsxfun(@minus, K, X1_row_sq);
        K2 = bsxfun(@minus, K2, X2_row_sq');
        KK = exp(K2 / (2*sigma^2));
%         KK = (1/(sigma*sqrt(2*pi)))*exp(K2 / (2*sigma^2));
    end
end







