function [PARAMS, RES] = train_ACD( Xtest,Ytest,Xtrain,Ytrain,LabelsTest,modelo,GRID)

if ~exist('GRID','var')
    GRID = [];
end

z_test   = [Xtest Ytest];
Z_train  = [Xtrain Ytrain];

if strcmp(modelo,'EC_ACD')
    [RES_aux,PARAMS_aux,AUCS,nu] = BEST_NU_EC_DEMO( z_test,Z_train,Xtest,Ytest,Xtrain,Ytrain,LabelsTest,GRID);
    
    PARAMS.nu_RX = PARAMS_aux(1);
    PARAMS.nu_YX = PARAMS_aux(2);
    PARAMS.nu_XY = PARAMS_aux(3);
    PARAMS.nu_HACD = PARAMS_aux(4);
    
    RES.nus = nu;
    
    RES.AUC_RX = AUCS.A_RX_ec;
    RES.AUC_YX = AUCS.A_XY_ec;
    RES.AUC_XY = AUCS.A_YX_ec;
    RES.AUC_HACD = AUCS.A_HACD_ec;
    
elseif strcmp(modelo,'K_ACD')
    
    [K_ACD_RX,K_ACD_YX,K_ACD_XY,K_ACD_HACD,grid_roscas_K_ACD,lambdas,MEDIAS] = best_parameters_K_ACD_val_DEMO(z_test,Z_train,Xtrain,Ytrain,Xtest,Ytest,LabelsTest,GRID);
    
    RES.m_sig_X = MEDIAS(2);
    RES.m_sig_Y = MEDIAS(3);
    RES.m_sig_Z = MEDIAS(1);
    
    RES.roscas = grid_roscas_K_ACD;
    RES.lambdas = lambdas;
    
    RES.AUC_K_ACD_RX = K_ACD_RX;
    RES.AUC_K_ACD_YX = K_ACD_YX;
    RES.AUC_K_ACD_XY = K_ACD_XY;
    RES.AUC_K_ACD_HACD = K_ACD_HACD;
    
    [xx yy] = find(K_ACD_RX==max(K_ACD_RX(:)));
    PARAMS.RX_rosca = RES.roscas(xx(1));
    PARAMS.RX_lambda = RES.lambdas(yy(1));
    
    PARAMS.RX_sigma_X = RES.m_sig_X*PARAMS.RX_rosca;
    PARAMS.RX_sigma_Y = RES.m_sig_Y*PARAMS.RX_rosca;
    PARAMS.RX_sigma_Z = RES.m_sig_Z*PARAMS.RX_rosca;
    
    [xx yy] = find(K_ACD_XY==max(K_ACD_XY(:)));
    PARAMS.XY_rosca = RES.roscas(xx(1));
    PARAMS.XY_lambda = RES.lambdas(yy(1));
    
    PARAMS.XY_sigma_X = RES.m_sig_X*PARAMS.XY_rosca;
    PARAMS.XY_sigma_Y = RES.m_sig_Y*PARAMS.XY_rosca;
    PARAMS.XY_sigma_Z = RES.m_sig_Z*PARAMS.XY_rosca;
    
    [xx yy] = find(K_ACD_YX==max(K_ACD_YX(:)));
    PARAMS.YX_rosca = RES.roscas(xx(1));
    PARAMS.YX_lambda = RES.lambdas(yy(1));
    
    PARAMS.YX_sigma_X = RES.m_sig_X*PARAMS.YX_rosca;
    PARAMS.YX_sigma_Y = RES.m_sig_Y*PARAMS.YX_rosca;
    PARAMS.YX_sigma_Z = RES.m_sig_Z*PARAMS.YX_rosca;
    
    [xx yy] = find(K_ACD_HACD==max(K_ACD_HACD(:)));
    PARAMS.HACD_rosca = RES.roscas(xx(1));
    PARAMS.HACD_lambda = RES.lambdas(yy(1));
    
    PARAMS.HACD_sigma_X = RES.m_sig_X*PARAMS.HACD_rosca;
    PARAMS.HACD_sigma_Y = RES.m_sig_Y*PARAMS.HACD_rosca;
    PARAMS.HACD_sigma_Z = RES.m_sig_Z*PARAMS.HACD_rosca;
    
elseif strcmp(modelo,'K_EC_ACD')
    [K_EC_ACD_RX,K_EC_ACD_YX,K_EC_ACD_XY,K_EC_ACD_HACD,grid_roscas_K_EC_ACD,grid_nu_K_EC_ACD,lambdas,MEDIAS]= best_parameters_KEC_ACD_DEMO(z_test,Z_train,Xtrain,Ytrain,Xtest,Ytest,LabelsTest,GRID);
    
    
    RES.m_sig_X = MEDIAS(2);
    RES.m_sig_Y = MEDIAS(3);
    RES.m_sig_Z = MEDIAS(1);
    
    RES.roscas = grid_roscas_K_EC_ACD;
    RES.nus = grid_nu_K_EC_ACD;
    RES.lambdas = lambdas;
    
    RES.AUC_K_EC_ACD_RX = K_EC_ACD_RX;
    RES.AUC_K_EC_ACD_YX = K_EC_ACD_YX;
    RES.AUC_K_EC_ACD_XY = K_EC_ACD_XY;
    RES.AUC_K_EC_ACD_HACD = K_EC_ACD_HACD;
    
    
    
    [ind_ros,ind_nu,ind_lam] = ind2sub(size(K_EC_ACD_RX),find(K_EC_ACD_RX == max(K_EC_ACD_RX(:))));
    
    PARAMS.RX_rosca = RES.roscas(ind_ros(1));
    PARAMS.RX_nu = RES.nus(ind_nu(1));
    PARAMS.RX_lambda = RES.lambdas(ind_lam(1));
    
    PARAMS.RX_sigma_X = RES.m_sig_X*PARAMS.RX_rosca;
    PARAMS.RX_sigma_Y = RES.m_sig_Y*PARAMS.RX_rosca;
    PARAMS.RX_sigma_Z = RES.m_sig_Z*PARAMS.RX_rosca;
    
    [ind_ros,ind_nu,ind_lam] = ind2sub(size(K_EC_ACD_XY),find(K_EC_ACD_XY == max(K_EC_ACD_XY(:))));
    
    PARAMS.XY_rosca = RES.roscas(ind_ros(1));
    PARAMS.XY_nu = RES.nus(ind_nu(1));
    PARAMS.XY_lambda = RES.lambdas(ind_lam(1));
    
    PARAMS.XY_sigma_X = RES.m_sig_X*PARAMS.XY_rosca;
    PARAMS.XY_sigma_Y = RES.m_sig_Y*PARAMS.XY_rosca;
    PARAMS.XY_sigma_Z = RES.m_sig_Z*PARAMS.XY_rosca;
    
    [ind_ros,ind_nu,ind_lam] = ind2sub(size(K_EC_ACD_YX),find(K_EC_ACD_YX == max(K_EC_ACD_YX(:))));
    
    PARAMS.YX_rosca = RES.roscas(ind_ros(1));
    PARAMS.YX_nu = RES.nus(ind_nu(1));
    PARAMS.YX_lambda = RES.lambdas(ind_lam(1));
    
    PARAMS.YX_sigma_X = RES.m_sig_X*PARAMS.YX_rosca;
    PARAMS.YX_sigma_Y = RES.m_sig_Y*PARAMS.YX_rosca;
    PARAMS.YX_sigma_Z = RES.m_sig_Z*PARAMS.YX_rosca;
    
    [ind_ros,ind_nu,ind_lam] = ind2sub(size(K_EC_ACD_HACD),find(K_EC_ACD_HACD == max(K_EC_ACD_HACD(:))));
    
    PARAMS.HACD_rosca = RES.roscas(ind_ros(1));
    PARAMS.HACD_nu = RES.nus(ind_nu(1));
    PARAMS.HACD_lambda = RES.lambdas(ind_lam(1));
    
    PARAMS.HACD_sigma_X = RES.m_sig_X*PARAMS.HACD_rosca;
    PARAMS.HACD_sigma_Y = RES.m_sig_Y*PARAMS.HACD_rosca;
    PARAMS.HACD_sigma_Z = RES.m_sig_Z*PARAMS.HACD_rosca;
    
end