

clc, clear;

    fontname = 'Helvetica';
    fontsize = 18;
    fontunits = 'points';
    set(0,'DefaultAxesFontName',fontname,'DefaultAxesFontSize',fontsize,'DefaultAxesFontUnits',fontunits,...
        'DefaultTextFontName',fontname,'DefaultTextFontSize',fontsize,'DefaultTextFontUnits',fontunits,...
        'DefaultLineLineWidth',3,'DefaultLineMarkerSize',20,'DefaultLineColor',[0 0 0]);


    % ADD ROUTES TO LOOK FOR IMAGES.
    addpath(genpath('/media/disk/erc/papers/ANOMALY_DETECTION/matlab/'))
    images_fold = '/media/disk/erc/papers/ANOMALY_DETECTION/matlab/Kernel_ACD/Imagenes_cross-validation_data/';
    DD= dir(images_fold);


%% CHOOSE THE IMAGE

ind = 7 ;                             % Order   ind =3 'ARGENTINA.mat';  ind =5 'CALIFORNIA.mat'; ind =7 'LAKE.mat';
load(DD(ind).name)                    %         ind =4 'AUSTRALIA.mat';  ind =6 'DENVER.mat';     ind =8 'ZURICH.mat'

labels(labels>0) = 1;                 % LABELS (0 and 1);

% PARAMETERS TO BE ADJUSTED.          % If yo don't want to tune the parameters, GRID = 0 and it generate a default GRID. 
GRID.roscas = [0 logspace(-3,6,60)];  % Kernel RBF.
GRID.nus = logspace(-5,10,100);       % Elliptically-contoured.
GRID.lambdas = logspace(-10,2.5,30);  % Kernel regularization.

% TEST and TRAIN pixeles amount.
numtest    = 4000;
numtrain   = 1000;

for seed=0:10                         % seed = generation of random pixel numbers for train and test.
    tic
    %% TRAINING
    % TRAINING in TRAIN(first part of the image)
    [Xtrain,Ytrain,Xtest,Ytest,LabelsTest]= TrainTestData_DEMO(Imagen1_Part1,Imagen2_Part1,numtest,numtrain,labels1_Part1,seed);
    
    % Returns the best parameter and AUC of the ellipticaly-contoured algorithm for each seed.
    model = 'EC_ACD';
    [PARAMS_EC, RES_EC] = train_ACD_DEMO( Xtest,Ytest,Xtrain,Ytrain,LabelsTest,model,GRID);    
    
    % Returns the best parameter and AUC of the linear kernel algorithm for each seed.
    model = 'K_ACD';
    [PARAMS_K, RES_K] = train_ACD_DEMO( Xtest,Ytest,Xtrain,Ytrain,LabelsTest,model,GRID);
    
    % Returns the best parameter and AUC of kernel ellipticaly-contoured algorithm for each seed.
    model = 'K_EC_ACD';
    [PARAMS_K_EC, RES_K_EC] = train_ACD_DEMO( Xtest,Ytest,Xtrain,Ytrain,LabelsTest,model,GRID);
    
    
       % Display the maximum values of AUC for each method in TRAIN(first part of the image).  
       [max(RES_EC.AUC_RX) max(RES_EC.AUC_YX) max(RES_EC.AUC_XY) max(RES_EC.AUC_HACD);
        max(RES_K.AUC_K_ACD_RX(:)) max(RES_K.AUC_K_ACD_YX(:)) max(RES_K.AUC_K_ACD_XY(:)) max(RES_K.AUC_K_ACD_HACD(:));
        max(RES_K_EC.AUC_K_EC_ACD_RX(:)) max(RES_K_EC.AUC_K_EC_ACD_YX(:)) max(RES_K_EC.AUC_K_EC_ACD_XY(:)) max(RES_K_EC.AUC_K_EC_ACD_HACD(:))]
    
    
    %% TESTING
    % TRAINING in TEST(second part of the image)
    [Xtrain_test,Ytrain_test,Xtest_test,Ytest_test,LabelsTest_test] = TrainTestData_DEMO(Imagen1_Part2,Imagen2_Part2,numtest,numtrain,labels2_Part2,seed);
    
    MMM(1).name = 'RX';
    MMM(2).name = 'YX';
    MMM(3).name = 'XY';
    MMM(4).name = 'HACD';
    
    % LINEAL ACD
    for ind_m=1:length(MMM)
        PARAMS = []; 
        method = MMM(ind_m).name;
        LIN(ind_m).RES = test_ACD_val_DEMO(Xtrain_test ,Ytrain_test ,Xtest_test ,Ytest_test,LabelsTest_test,PARAMS,method);
        LIN(ind_m).name = method;
    end
    
    % EC ACD
    % PARAMS_EC variable contains the best parameters for Elliptically-contoured methods.
    for ind_m=1:length(MMM)
        method = ['EC_' MMM(ind_m).name];
        EC(ind_m).RES = test_ACD_val_DEMO(Xtrain_test ,Ytrain_test ,Xtest_test ,Ytest_test,LabelsTest_test,PARAMS_EC,method);
        EC(ind_m).name = method;
    end
    
    % K ACD
    % PARAMS_K variable contains the best parameters for Kernel linear methods.
    for ind_m=1:length(MMM)
        method = ['K_' MMM(ind_m).name];
        K(ind_m).RES = test_ACD_val_DEMO(Xtrain_test ,Ytrain_test ,Xtest_test ,Ytest_test,LabelsTest_test,PARAMS_K,method);
        K(ind_m).name = method;
    end
    
    % K EC ACD
    % PARAMS_K_EC variable contains the best parameters for Kernel Elliptically-contoured methods.
    for ind_m=1:length(MMM)
        method = ['K_EC_' MMM(ind_m).name];
        K_EC(ind_m).RES = test_ACD_val_DEMO(Xtrain_test ,Ytrain_test ,Xtest_test ,Ytest_test,LabelsTest_test,PARAMS_K_EC,method);
        K_EC(ind_m).name = method;
    end
    
   
    % AUC RESULTS ALL METHODS.
    [cat(1,LIN(1).RES.AUC) cat(1,LIN(2).RES.AUC) cat(1,LIN(3).RES.AUC) cat(1,LIN(4).RES.AUC);
     cat(1,EC(1).RES.AUC) cat(1,EC(2).RES.AUC) cat(1,EC(3).RES.AUC) cat(1,EC(4).RES.AUC);
     cat(1,K(1).RES.AUC) cat(1,K(2).RES.AUC) cat(1,K(3).RES.AUC) cat(1,K(4).RES.AUC);
     cat(1,K_EC(1).RES.AUC) cat(1,K_EC(2).RES.AUC) cat(1,K_EC(3).RES.AUC) cat(1,K_EC(4).RES.AUC);]
   
    toc
end
