
clc, clear all;

fontname = 'Helvetica';
fontsize = 18;
fontunits = 'points';
set(0,'DefaultAxesFontName',fontname,'DefaultAxesFontSize',fontsize,'DefaultAxesFontUnits',fontunits,...
    'DefaultTextFontName',fontname,'DefaultTextFontSize',fontsize,'DefaultTextFontUnits',fontunits,...
    'DefaultLineLineWidth',3,'DefaultLineMarkerSize',20,'DefaultLineColor',[0 0 0]);


% ADD ROUTES TO LOOK FOR IMAGES.
images_fold = '/media/disk/erc/papers/ANOMALY_DETECTION/matlab/Kernel_ACD/Imagenes_cross-validation_data/';
DD= dir(images_fold);


%% CHOOSE THE IMAGE

ind = 7 ;                             % Order   ind =3 'ARGENTINA.mat';  ind =5 'CALIFORNIA.mat'; ind =7 'LAKE.mat';
load(DD(ind).name)                    %         ind =4 'AUSTRALIA.mat';  ind =6 'DENVER.mat';     ind =8 'ZURICH.mat'

labels(labels>0) = 1;                 % LABELS (0 and 1);

% PARAMETERS TO BE ADJUSTED
GRID.roscas = [0 logspace(-3,6,60)];  % Kernel RBF.
GRID.nus = logspace(-5,10,100);       % Elliptically-contoured.
GRID.lambdas = logspace(-10,2.5,30);  % Kernel regularization.

% TEST and TRAIN pixeles amount.
numtest    = 4000;
numtrain   = 1000;

for seed=0:10
    
      %% TESTING
    % TRAINING in TEST(second part of the image)
    [Xtrain_test,Ytrain_test,Xtest_test,Ytest_test,LabelsTest_test] = TrainTestData_DEMO(Imagen1,Imagen2,numtest,numtrain,labels2,seed);
    
    MMM(1).name = 'RX';
    MMM(2).name = 'YX';
    MMM(3).name = 'XY';
    MMM(4).name = 'HACD';
    
    % LINEAL ACD
    for ind_m=1:length(MMM)
        PARAMS = [];
        method = MMM(ind_m).name;
        LIN(ind_m).RES = test_ACD_val_DEMO(Xtrain_test ,Ytrain_test ,Xtest_test ,Ytest_test,LabelsTest_test,PARAMS,method);
        LIN(ind_m).name = method;
    end
    
    % EC ACD
    for ind_m=1:length(MMM)
        method = ['EC_' MMM(ind_m).name];
        EC(ind_m).RES = test_ACD_val_DEMO(Xtrain_test ,Ytrain_test ,Xtest_test ,Ytest_test,LabelsTest_test,PARAMS_EC,method);
        EC(ind_m).name = method;
    end
    
    % K ACD
    for ind_m=1:length(MMM)
        method = ['K_' MMM(ind_m).name];
        K(ind_m).RES = test_ACD_val_DEMO(Xtrain_test ,Ytrain_test ,Xtest_test ,Ytest_test,LabelsTest_test,PARAMS_K,method);
        K(ind_m).name = method;
    end
    
    % K EC ACD
    for ind_m=1:length(MMM)
        method = ['K_EC_' MMM(ind_m).name];
        K_EC(ind_m).RES = test_ACD_val_DEMO(Xtrain_test ,Ytrain_test ,Xtest_test ,Ytest_test,LabelsTest_test,PARAMS_K_EC,method);
        K_EC(ind_m).name = method;
    end

    % AUC RESULTS
    [cat(1,LIN(1).RES.AUC) cat(1,LIN(2).RES.AUC) cat(1,LIN(3).RES.AUC) cat(1,LIN(4).RES.AUC);
     cat(1,EC(1).RES.AUC) cat(1,EC(2).RES.AUC) cat(1,EC(3).RES.AUC) cat(1,EC(4).RES.AUC);
     cat(1,K(1).RES.AUC) cat(1,K(2).RES.AUC) cat(1,K(3).RES.AUC) cat(1,K(4).RES.AUC);
     cat(1,K_EC(1).RES.AUC) cat(1,K_EC(2).RES.AUC) cat(1,K_EC(3).RES.AUC) cat(1,K_EC(4).RES.AUC);]

    toc
end