
clc, clear all;

fontname = 'Helvetica';
fontsize = 18;
fontunits = 'points';
set(0,'DefaultAxesFontName',fontname,'DefaultAxesFontSize',fontsize,'DefaultAxesFontUnits',fontunits,...
    'DefaultTextFontName',fontname,'DefaultTextFontSize',fontsize,'DefaultTextFontUnits',fontunits,...
    'DefaultLineLineWidth',3,'DefaultLineMarkerSize',20,'DefaultLineColor',[0 0 0]);


% ADD ROUTES TO LOOK FOR IMAGES.
addpath(genpath('/media/disk/erc/papers/ANOMALY_DETECTION/matlab/'))
images_fold = '/media/disk/erc/papers/ANOMALY_DETECTION/matlab/Kernel_ACD/Imagenes_cross-validation_data/';
DD= dir(images_fold);


%% CHOOSE THE IMAGE

ind = 7 ;                              % Order   ind =3 'ARGENTINA.mat';  ind =5 'CALIFORNIA.mat'; ind =7 'LAKE.mat';
load(DD(ind).name)                     %         ind =4 'AUSTRALIA.mat';  ind =6 'DENVER.mat';     ind =8 'ZURICH.mat'

labels(labels>0) = 1;                  % LABELS (0 and 1);

% PARAMETERS TO BE ADJUSTED.
GRID.roscas = [0 logspace(-3,6,60)];   % Kernel RBF.
GRID.nus = logspace(-5,10,100);        % Elliptically-contoured.
GRID.lambdas = logspace(-10,2.5,30);   % Kernel regularization.

% TEST and TRAIN pixeles amount.
numtest    = 4000;
numtrain   = 1000;

for seed=0:10
    tic
    %% TRAINING
    % TRAINING in TRAIN(first part of the image)
    [Xtrain,Ytrain,Xtest,Ytest,LabelsTest]= TrainTestData_DEMO(Imagen1,Imagen2,numtest,numtrain,labels1,seed);
    
    model = 'EC_ACD';
    [PARAMS_EC, RES_EC] = train_ACD_DEMO( Xtest,Ytest,Xtrain,Ytrain,LabelsTest,model,GRID);
    
    model = 'K_ACD';
    [PARAMS_K, RES_K] = train_ACD_DEMO( Xtest,Ytest,Xtrain,Ytrain,LabelsTest,model,GRID);
    
    model = 'K_EC_ACD';
    [PARAMS_K_EC, RES_K_EC] = train_ACD_DEMO( Xtest,Ytest,Xtrain,Ytrain,LabelsTest,model,GRID);
 
    % AUC RESULTS.
    [max(RES_EC.AUC_RX) max(RES_EC.AUC_YX) max(RES_EC.AUC_XY) max(RES_EC.AUC_HACD);
     max(RES_K.AUC_K_ACD_RX(:)) max(RES_K.AUC_K_ACD_YX(:)) max(RES_K.AUC_K_ACD_XY(:)) max(RES_K.AUC_K_ACD_HACD(:));
     max(RES_K_EC.AUC_K_EC_ACD_RX(:)) max(RES_K_EC.AUC_K_EC_ACD_YX(:)) max(RES_K_EC.AUC_K_EC_ACD_XY(:)) max(RES_K_EC.AUC_K_EC_ACD_HACD(:))]
    
    
end