function [CSFet,csf_fx_ft,fxx,ftt]=spatio_temp_csf(fse,fst,Nx,Nt,estab,fy0);

%
% SPATIO_TEMP_CSF computes the spatio-temporal CSF of Kelly with or without
% eye movement stabilization in the 3D Fourier domain defined by the
% sampling parameters defined by the user.
%
% The program returs:
%  (1) Data of the 3d CSF in 2d array format.
%
%  (2) The 2d values of the 3D function in the fx,ft plane (for a certain 
%      value of fy) and the 1d variables fx and ft to represent this plane
%      with imagesc.
%
% SYNTAX:  [csfet,csf_fx_ft,fx,ft] = spatio_temp_csf(fsx,fst,Nx,Nt,stabiliz?,fy0);
%

% [fx,fy,ft]=dominio_freq_espacio_temp(fse,fst,Nx,Nx,Nt);
[x,y,t,fx,fy,ft] = spatio_temp_freq_domain(Nx,Nx,Nt,fse,fst);

for i=1:Nt
    f=sacafot(ft,Nx,Nx,i);
    ftt(i)=f(1,1);
end

F=sqrt(fx.^2+fy.^2);

ft=abs(ft)+0.0000000000001;
F=F+0.0000000000001;

if estab==1
   CSFet=4*pi^2*F.*abs(ft).*exp(-4*pi*(ft+2*F)/45.9).*(6.1+7.3*abs(log10(abs(ft)./(3*F))).^3);
else
   ft=abs(ft)+0.1*F;
   CSFet=4*pi^2*F.*abs(ft).*exp(-4*pi*(ft+2*F)/45.9).*(6.1+7.3*abs(log10(abs(ft)./(3*F))).^3);    
end    

[m,I]=min( abs(fy(:,1)-fy0) );

csf_fx_ft=zeros(Nx,Nt);
for i=1:Nx
    csf_fx_ft(i,:)=slineat(CSFet,[I i]);
end 

fxx=fx(1,1:Nx);