%
% Demo 1a: Computing a kernel matrix with training and test data 
% 
% Gustavo Camps-Valls, gustavo.camps@uv.es, http://isp.uv.es
% 2014(c)
%
%

clear; clc; close all;

randn('seed',1234)
rand('seed',1234)

%% Generate toy dataset
method = 'moons'
n = 10 % number of training points per class
[Xtr,Ytr] = generate_toydata(n,method);
n = 500 % number of testing points per class
[Xte,Yte] = generate_toydata(n,method);

%% Plot the data distributions
figure, scatter(Xtr(:,1),Xtr(:,2),80,Ytr,'f'), hold on,
scatter(Xte(:,1),Xte(:,2),20,Yte),axis off square

%% Compute the kernel matrices
K_ideal_trtr = Ytr*Ytr';
K_ideal_trte = Ytr*Yte';
K_lin_trtr   = kernelmatrix('lin',Xtr',Xtr',[]); 
K_lin_trte   = kernelmatrix('lin',Xtr',Xte',[]); 
K_pol_trtr   = kernelmatrix('poly',Xtr',Xtr',2); 
K_pol_trte   = kernelmatrix('poly',Xtr',Xte',2); 
sigma = median(pdist(Xtr));  % heuristic
K_rbf_trtr   = kernelmatrix('rbf',Xtr',Xtr',sigma); 
K_rbf_trte   = kernelmatrix('rbf',Xtr',Xte',sigma); 

%% Compute the distance to the ideal kernel
clc
mse_lin_trtr = norm(K_lin_trtr-K_ideal_trtr,'fro')
mse_lin_trte = norm(K_lin_trte-K_ideal_trte,'fro')
mse_pol_trtr = norm(K_pol_trtr-K_ideal_trtr,'fro')
mse_pol_trte = norm(K_pol_trte-K_ideal_trte,'fro')
mse_rbf_trtr = norm(K_rbf_trtr-K_ideal_trtr,'fro')
mse_rbf_trte = norm(K_rbf_trte-K_ideal_trte,'fro')

figure,
  subplot(4,2,1), imagesc(K_ideal_trtr),axis off square, title('Ideal kernel (train)')
  subplot(4,2,2), imagesc(K_ideal_trte),axis off tight, title('Ideal kernel (train-test)')
  subplot(4,2,3), imagesc(K_lin_trtr),axis off square, title('Linear kernel (train)')
  subplot(4,2,4), imagesc(K_lin_trte),axis off tight, title('Linear kernel (train-test)')
  subplot(4,2,5), imagesc(K_pol_trtr),axis off square, title('Polynomial kernel (train)')
  subplot(4,2,6), imagesc(K_pol_trte),axis off tight, title('Polynomial kernel (train-test)')
  subplot(4,2,7), imagesc(K_rbf_trtr),axis off square, title('RBF kernel (train)')
  subplot(4,2,8), imagesc(K_rbf_trte),axis off tight, title('RBF kernel (train-test)')

  