%
% Demo 1b: Simple properties of kernel functions
%
% Gustavo Camps-Valls, gustavo.camps@uv.es, http://isp.uv.es
% 2014(c)
%
%

clear; clc; close all;

randn('seed',1234)
rand('seed',1234)

%% Generate toy dataset
method = 'moons'
n = 100 % number of training points per class
[Xtr,Ytr] = generate_toydata(n,method);

%% Plot the data distributions
figure, scatter(Xtr(:,1),Xtr(:,2),80,Ytr,'f'), hold on, axis off

%% Compute the RBF kernel matrix
sigma = median(pdist(Xtr));  % heuristic
K = kernelmatrix('rbf',Xtr',Xtr',sigma);

%% Property 1: is this a valid positive definite kernel?
[V D] = eigs(K,2*n);
figure,
semilogy(diag(D),'linewidth',6),
grid,xlabel('i'),ylabel('\lambda_i'),title('Eigenvalues')
all(diag(D)>=0)
% >>>> Homework 1: what's the impact of the sigma parameter on the eigenvalues? Do you
% have an intuition on this?

%% Property 2: Center the data in feature spaces
Kc = kernelcentering(K);
% >>>> Homework 2: study this function and try to center test data

%% Property 3: normalize a kernel
Kn = kernelnormalization(K);

figure,
subplot(221),imagesc(K),axis off square, colorbar, title('Uncentered kernel')
subplot(222),imagesc(Kc), axis off square, colorbar, title('Centered kernel')
subplot(223),imagesc(Kn), axis off square, colorbar, title('Normalized kernel')
subplot(224),imagesc(abs(K-Kn)), axis off square, colorbar, title('|Kernel - normalized kernel|')
% >>>> Homework 3: why the RBF kernel does not change when it is normalized?

%% Property 4: compute distances between data points in Hilbert space from the kernel
for i=1:2*n
    for j=1:2*n
        Dist2_X(i,j) = norm(Xtr(i,:)-Xtr(j,:),'fro');
        Dist2_H(i,j) = K(i,i)+K(j,j)-2*K(i,j);
    end
end
figure,
   plot(Dist2_X,Dist2_H,'k.','markersize',10),
   xlabel('Distances in input space')
   ylabel('Distances in Hilbert space')
   grid
   
   
