%
% Demo 1c: Tuning the RBF kernel parameters with alignment
% 
% Gustavo Camps-Valls, gustavo.camps@uv.es, http://isp.uv.es
% 2014(c)
%
%

clear; clc; close all;

randn('seed',1234)
rand('seed',1234)

addpath('./svm_code')

%% Generate toy dataset
method = 'moons'
n = 200 % number of training points per class
[X,Y] = generate_toydata(n,method);

%% Plot the data distributions
figure, scatter(X(:,1),X(:,2),80,Y,'f'), hold on, axis off

%% Compute the RBF kernel matrix
sigma = median(pdist(X));  % heuristic (rule of thumb)
K = kernelmatrix('rbf',X',X',sigma); 

%% Let's run the kernel alignment:
Ky = kernelcentering(Y*Y'); % ideal kernel
SIGMAS = logspace(-3,3,100)
s=0;
for sigma=SIGMAS
    s=s+1;
    K = kernelcentering(kernelmatrix('rbf',X',X',sigma));
    A(s) = alignment(K,Ky);
    
    % Training a SVM
    OA(s) = svmtrain(Y,K,'-s 0 -t 4 -v 10 -c 10');

end

figure,
   semilogx(SIGMAS,scale(A'),'r','linewidth',6),hold on
   semilogx(SIGMAS,scale(OA'),'g','linewidth',6),
   grid,xlabel('\sigma'),title('Alignment')
   legend('Alignment','10-fold SVM')
   
   