%
% Demo 2a: Kernel ridge regression
% 
% Gustavo Camps-Valls, gustavo.camps@uv.es, http://isp.uv.es
% 2014(c)
%

clear; clc; close all;

randn('seed',1234)
rand('seed',1234)

%% Load dataset
load motorcycle.mat
[n d] = size(X);
r = randperm(n);
ntr = 100;
idtr = r(1:ntr);
idte = r(ntr+1:end);
Xtr = X(idtr,:);
Xte = X(idte,:);
Ytr = y(idtr,:);
Yte = y(idte,:);

%% Plot the data
figure, 
plot(Xtr,Ytr,'k.'), hold on,
plot(Xte,Yte,'r.'),
legend('Train','Test')

%% Compute the kernel matrices
sigma = median(pdist(Xtr));  % heuristic
K     = kernelmatrix('rbf',X',Xtr',sigma); 
Ktr   = kernelmatrix('rbf',Xtr',Xtr',sigma); 
Kte   = kernelmatrix('rbf',Xte',Xtr',sigma); 

%% KRR
gamma = 1e-5;
alpha = (Ktr + gamma*eye(ntr))\Ytr;

%% Predict on the test data
Yp_te = Kte*alpha;
assessment(Yte,Yp_te,'regress') % perf

%% Predict on all the data
Yp = K*alpha;
figure, 
plot(X,y,'k.'), hold on,
plot(X,Yp,'b'),
legend('Y','Y_p')

% >>>> Homework 4: Play around with the sigma parameter: explain the results obtained when
% sigma is very small and very large. Hint: look at the ideal kernel and the alignment







