%
% Demo 2b: Least squares SVM
% 
% Gustavo Camps-Valls, gustavo.camps@uv.es, http://isp.uv.es
% 2014(c)
%

clear; clc; close all;

randn('seed',1234)
rand('seed',1234)

%% Generate toy dataset
method = 'moons'
n = 300 % number of training points per class
[X,Y] = generate_toydata(n,method);
[n d] = size(X);
r = randperm(n);
ntr  = 20;
idtr = r(1:ntr);
idte = r(ntr+1:end);
Xtr = X(idtr,:);
Xte = X(idte,:);
Ytr = Y(idtr,:);
Yte = Y(idte,:);

%% Class encoding: Y={1,2} ---> {-1,1}
Y   = 2*Y-3;
Ytr = 2*Ytr-3;
Yte = 2*Yte-3;

%% Plot the data distributions
figure, scatter(Xtr(:,1),Xtr(:,2),80,Ytr,'f'), hold on, axis off
        scatter(Xte(:,1),Xte(:,2),20,Yte), hold on, axis off

%% Compute the kernel matrices
sigma = median(pdist(Xtr));  % heuristic
K     = kernelmatrix('rbf',X',Xtr',sigma); 
Ktr   = kernelmatrix('rbf',Xtr',Xtr',sigma); 
Kte   = kernelmatrix('rbf',Xte',Xtr',sigma); 

%% LS-SVM
gamma= 1e-2;
alpha = (Ktr + gamma*eye(ntr))\Ytr;

%% Predict on the test data
Yp_te = sign(Kte*alpha);
results = assessment(Yte,Yp_te,'class')

%% Predict on all the data
Yp = sign(K*alpha);
figure, scatter(X(:,1),X(:,2),80,Y~=Yp,'f'), hold on, axis off
title('Errors in red')

% >>>> Homework 5: Play around with the sigma parameter: explain the results obtained when
% sigma is very small and very large. Hint: look at the ideal kernel and the alignment
