%
% Demo 3: kernel PCA
%
% Gustavo Camps-Valls, gustavo.camps@uv.es, http://isp.uv.es
% 2014(c)
%

clear; clc; close all;

randn('seed',1234)
rand('seed',1234)

%% Generate toy dataset
method = 'moons'
n = 1000 % number of training points per class
[X,Y] = generate_toydata(n,method);
[n d] = size(X);
r = randperm(n);
ntr  = 200;
idtr = r(1:ntr);
idte = r(ntr+1:end);
Xtr = X(idtr,:);
Xte = X(idte,:);
Ytr = Y(idtr,:);
Yte = Y(idte,:);

%% Plot the data distributions
figure, scatter(Xtr(:,1),Xtr(:,2),80,Ytr,'f'), hold on, axis off
scatter(Xte(:,1),Xte(:,2),20,Yte), hold on, axis off

%% Compute the kernel matrices
sigma = median(pdist(Xtr));  % heuristic
Ktr   = kernelmatrix('rbf',Xtr',Xtr',sigma);
Kte   = kernelmatrix('rbf',Xte',Xtr',sigma);

%% KPCA
[A L] = eigs(Ktr,ntr);
figure,
semilogy(diag(L),'linewidth',6),
grid,xlabel('i'),ylabel('\lambda_i'),title('Eigenvalues')
all(diag(L)>=0)

%% Project the test data for different number of components
Nf = min(ntr,rank(Ktr))
for k=1:Nf
    
    Ptr = Ktr*A(:,1:k);
    Pte = Kte*A(:,1:k);
    
    % Train a linear classifier with the projected data
    Yp_tr = classify(Ptr,Ptr,Ytr);
    Yp_te = classify(Pte,Ptr,Ytr);
    
    % Store the results
    results_tr = assessment(Ytr,Yp_tr,'class');
    OAtr(k) = results_tr.OA;
    results_te = assessment(Yte,Yp_te,'class');
    OAte(k) = results_te.OA;
end

figure,semilogy(100-OAtr,'b','linewidth',6),hold on, 
       semilogy(100-OAte,'r--','linewidth',6)
xlabel('number of kernel PCA components')
ylabel('prediction errors (%)')
legend('training error','test error')
grid

%% Visualize the projections
plotKernelFeatures(Xtr,Ytr,sigma,A)

% >>>> Homework 6: Play around with the sigma parameter: explain the results obtained when
% sigma is very small and very large. 
%    Hints: 
%       - look at the ideal kernel and the alignment,
%       - think of a big sigma as approaching the linear kernel

