
function plotKernelFeatures(Data,Labels,sigma,A)

% V = real(V);

% Create the grid for testing the projections
gr = 30;
x1min = 2*min(Data(:,1));  x1max = 2*max(Data(:,1));
x2min = 2*min(Data(:,2));  x2max = 2*max(Data(:,2));
[X,Y] = meshgrid(linspace(x1min,x1max,gr),linspace(x2min,x2max,gr));
Z = [X(:) , Y(:)];

% Create the grid-to-training kernel
Ktest = kernelmatrix('rbf',Z',Data',sigma);

% Project the test points onto the eigenvectors
phiZ = Ktest * A;

% Plot the first 9 feature maps only
figure,
for i=1:9
    subplot(3,3,i)
    plot(Data(Labels==1,1),Data(Labels==1,2),'r.'), hold on
    plot(Data(Labels==2,1),Data(Labels==2,2),'b.'),
    pcolor(X,Y,reshape(phiZ(:,i),[gr gr])),colormap gray
    contour(X,Y,reshape(phiZ(:,i),[gr gr]),8,'w')
    shading interp
    axis square off
    title(['Feature ' num2str(i)])
end

