class LayerNorm(Module):
  __parameters__ = ["gamma", "beta", ]
  __buffers__ = []
  gamma : Tensor
  beta : Tensor
  training : bool
  _is_full_backward_hook : Optional[bool]
  def forward(self: __torch__.toolbox.torchtext.modules.layer_norm.___torch_mangle_23.LayerNorm,
    tensor: Tensor) -> Tensor:
    beta = self.beta
    gamma = self.gamma
    mean = torch.mean(tensor, [-1], True)
    std = torch.std(tensor, [-1], False, True)
    _0 = torch.mul(gamma, torch.sub(tensor, mean))
    _1 = torch.div(_0, torch.add(std, CONSTANTS.c0))
    return torch.add(_1, beta)
